/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.commons.io;

import com.wavemaker.commons.io.File;
import com.wavemaker.commons.io.local.LocalFile;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.nio.file.Files;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteTempFileOnCloseInputStream
extends FileInputStream {
    private final java.io.File tempFile;
    private static final Logger logger = LoggerFactory.getLogger(DeleteTempFileOnCloseInputStream.class);

    public DeleteTempFileOnCloseInputStream(java.io.File tempFile) throws FileNotFoundException {
        super(tempFile);
        this.tempFile = tempFile;
        TempFileManager.register(this, tempFile);
    }

    public DeleteTempFileOnCloseInputStream(File tempFile) throws FileNotFoundException {
        this(((LocalFile)tempFile).getLocalFile());
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.deleteTempFile();
        TempFileManager.unregister(this);
    }

    public java.io.File getTempFile() {
        return this.tempFile;
    }

    private void deleteTempFile() {
        try {
            Files.deleteIfExists(this.tempFile.toPath());
        }
        catch (Exception e) {
            logger.warn("Unable to delete the temp file {} on closing the stream.", (Object)this.tempFile, (Object)e);
        }
    }

    public static class TempFileManager {
        private static ScheduledExecutorService scheduler;
        private static final Map<WeakReference<DeleteTempFileOnCloseInputStream>, java.io.File> objectsMap;

        private TempFileManager() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void stopScheduler() {
            Class<TempFileManager> clazz = TempFileManager.class;
            synchronized (TempFileManager.class) {
                if (scheduler != null && !scheduler.isShutdown()) {
                    logger.info("Shutting down temp-file-delete-thread");
                    scheduler.shutdown();
                }
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
        }

        private static void register(DeleteTempFileOnCloseInputStream stream, java.io.File tempFile) {
            objectsMap.put(new WeakReference<DeleteTempFileOnCloseInputStream>(stream), tempFile);
            TempFileManager.startSchedulerIfNeeded();
        }

        private static void unregister(DeleteTempFileOnCloseInputStream stream) {
            objectsMap.keySet().removeIf(weakReference -> weakReference.get() == stream);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void startSchedulerIfNeeded() {
            Class<TempFileManager> clazz = TempFileManager.class;
            synchronized (TempFileManager.class) {
                if (scheduler == null || scheduler.isShutdown()) {
                    scheduler = Executors.newSingleThreadScheduledExecutor(runnable -> {
                        Thread thread = new Thread(runnable, "temp-file-delete-thread");
                        thread.setUncaughtExceptionHandler((t, e) -> logger.error("Exception in thread {}", (Object)t, (Object)e));
                        return thread;
                    });
                    logger.info("Starting temp-file-delete-thread for temp files clean up");
                    scheduler.scheduleAtFixedRate(TempFileManager::cleanUpTempFiles, 1L, 5L, TimeUnit.MINUTES);
                }
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
        }

        private static void cleanUpTempFiles() {
            logger.info("Trying to clean up temp files that are unreferenced");
            Iterator<Map.Entry<WeakReference<DeleteTempFileOnCloseInputStream>, java.io.File>> iterator = objectsMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<WeakReference<DeleteTempFileOnCloseInputStream>, java.io.File> entry = iterator.next();
                WeakReference<DeleteTempFileOnCloseInputStream> weakReference = entry.getKey();
                if (weakReference.get() != null) continue;
                java.io.File tempFile = entry.getValue();
                try {
                    Files.deleteIfExists(tempFile.toPath());
                    iterator.remove();
                }
                catch (Exception e) {
                    logger.warn("Unable to delete the temp file {} during cleanup.", (Object)tempFile, (Object)e);
                }
            }
        }

        static {
            objectsMap = new ConcurrentHashMap<WeakReference<DeleteTempFileOnCloseInputStream>, java.io.File>();
        }
    }
}

