/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.commons.io;

import com.wavemaker.commons.io.ResourcePath;
import com.wavemaker.commons.io.ResourceStringFormat;
import org.springframework.util.Assert;

public final class JailedResourcePath {
    private final ResourcePath jailPath;
    private final ResourcePath path;

    public JailedResourcePath(ResourcePath jailPath, ResourcePath path) {
        Assert.notNull((Object)jailPath, (String)"JailPath must not be null");
        Assert.notNull((Object)path, (String)"Path must not be null");
        this.path = path;
        this.jailPath = jailPath;
    }

    public JailedResourcePath() {
        this.jailPath = new ResourcePath();
        this.path = new ResourcePath();
    }

    public ResourcePath getJailPath() {
        return this.jailPath;
    }

    public ResourcePath getPath() {
        return this.path;
    }

    public JailedResourcePath getParent() {
        ResourcePath parent = this.path.getParent();
        if (parent == null) {
            return null;
        }
        return new JailedResourcePath(this.jailPath, parent);
    }

    public JailedResourcePath get(String path) {
        return new JailedResourcePath(this.jailPath, this.path.get(path));
    }

    public ResourcePath getUnjailedPath() {
        return this.jailPath.append(this.path);
    }

    public JailedResourcePath unjail() {
        return new JailedResourcePath(new ResourcePath(), this.getUnjailedPath());
    }

    public String toString() {
        return this.getPath().toString();
    }

    public int hashCode() {
        return this.jailPath.hashCode() + 31 * this.path.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JailedResourcePath other = (JailedResourcePath)obj;
        return this.jailPath.equals(other.jailPath) && this.path.equals(other.path);
    }

    public String toString(ResourceStringFormat format) {
        ResourceStringFormat resourceStringFormat = format = format == null ? ResourceStringFormat.FULL : format;
        if (format == ResourceStringFormat.FULL) {
            return this.getPath().toString();
        }
        if (format == ResourceStringFormat.UNJAILED) {
            return this.getUnjailedPath().toString();
        }
        throw new UnsupportedOperationException("Unable to display path with the format " + String.valueOf((Object)format));
    }
}

