/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.commons.io;

import com.google.common.collect.Maps;
import com.wavemaker.commons.io.File;
import com.wavemaker.commons.io.ResourceOperation;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.PropertySources;
import org.springframework.core.env.PropertySourcesPropertyResolver;

public class PropertySourcesPropertyResolverOperation
implements ResourceOperation<File> {
    private final PropertySourcesPropertyResolver propertyResolver;

    public PropertySourcesPropertyResolverOperation(Properties properties) {
        MapPropertySource mapPropertySource = new MapPropertySource("propertySource", new HashMap());
        ((Map)mapPropertySource.getSource()).putAll(Maps.fromProperties((Properties)properties));
        MutablePropertySources propertySources = new MutablePropertySources();
        propertySources.addFirst((PropertySource)mapPropertySource);
        this.propertyResolver = new PropertySourcesPropertyResolver((PropertySources)propertySources);
    }

    @Override
    public void perform(File resource) {
        String originalContent;
        String content = originalContent = resource.getContent().asString();
        if (!Objects.equals(content = this.propertyResolver.resolvePlaceholders(content), originalContent)) {
            resource.getContent().write(content);
        }
    }
}

