/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.commons.io;

import java.io.Serializable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public final class ResourcePath
implements Serializable {
    private final ResourcePath parent;
    private final String name;

    public ResourcePath() {
        this(null, "");
    }

    private ResourcePath(ResourcePath parent, String name) {
        Assert.notNull((Object)name, (String)"Name must not be null");
        this.parent = parent;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        if (this.parent != null) {
            return String.valueOf(this.parent) + "/" + this.name;
        }
        return this.name;
    }

    public String toStringRelativeTo(String source) {
        Assert.notNull((Object)source, (String)"Source must not be null");
        return this.toStringRelativeTo(new ResourcePath().get(source));
    }

    public String toStringRelativeTo(ResourcePath source) {
        Assert.notNull((Object)source, (String)"Source must not be null");
        if (source.equals(this)) {
            return "";
        }
        String sourcePath = String.valueOf(source) + "/";
        Assert.isTrue((boolean)this.toString().startsWith(sourcePath), (String)("Source '" + String.valueOf(source) + "' must be a parent of '" + String.valueOf(this) + "'"));
        return this.toString().substring(sourcePath.length());
    }

    public ResourcePath get(String path) {
        Assert.hasLength((String)path, (String)"Path must not be empty");
        ResourcePath rtn = this;
        if (path.startsWith("/")) {
            rtn = new ResourcePath();
            path = path.substring(1);
        }
        while (path.indexOf(47) != -1) {
            rtn = rtn.newPath(path.substring(0, path.indexOf(47)));
            path = path.substring(path.indexOf(47) + 1);
        }
        return rtn.newPath(path);
    }

    private ResourcePath newPath(String name) {
        if ("".equals(name)) {
            return this;
        }
        if ("..".equals(name)) {
            Assert.state((this.parent != null ? 1 : 0) != 0, (String)"[Assertion failed] - Parent cannot be null");
            return this.parent;
        }
        return new ResourcePath(this, name);
    }

    public ResourcePath getParent() {
        return this.parent;
    }

    public boolean isRootPath() {
        if (this.parent != null) {
            return false;
        }
        return "".equals(this.name);
    }

    public ResourcePath append(ResourcePath path) {
        Assert.notNull((Object)path, (String)"Path must not be null");
        if (path.isRootPath()) {
            return this;
        }
        if (path.getParent() == null) {
            return new ResourcePath(this, path.getName());
        }
        return new ResourcePath(this.append(path.getParent()), path.getName());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof ResourcePath) {
            ResourcePath other = (ResourcePath)obj;
            return ObjectUtils.nullSafeEquals((Object)this.getParent(), (Object)other.getParent()) && this.name.equals(other.name);
        }
        return false;
    }
}

