/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.commons.io;

import com.wavemaker.commons.io.AbstractResources;
import com.wavemaker.commons.io.Folder;
import com.wavemaker.commons.io.Resource;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import org.springframework.util.Assert;

public class ResourcesCollection<T extends Resource>
extends AbstractResources<T> {
    private final Folder source;
    private final Collection<T> resources;

    public ResourcesCollection(Folder source, Collection<T> resources) {
        Assert.notNull((Object)source, (String)"Source must not be null");
        Assert.notNull(resources, (String)"Resources must not be null");
        this.source = source;
        this.resources = resources;
    }

    public ResourcesCollection(Folder source, T ... resources) {
        Assert.notNull((Object)source, (String)"Source must not be null");
        Assert.notNull(resources, (String)"Resources must not be null");
        this.source = source;
        this.resources = Arrays.asList(resources);
    }

    @Override
    public Folder getSource() {
        return this.source;
    }

    @Override
    public Iterator<T> iterator() {
        return this.resources.iterator();
    }
}

