/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.commons.io.store;

import com.wavemaker.commons.ResourceAlreadyExistException;
import com.wavemaker.commons.io.AbstractFileContent;
import com.wavemaker.commons.io.File;
import com.wavemaker.commons.io.FileContent;
import com.wavemaker.commons.io.Folder;
import com.wavemaker.commons.io.exception.ResourceException;
import com.wavemaker.commons.io.store.FileStore;
import com.wavemaker.commons.io.store.StoredResource;
import com.wavemaker.commons.util.WMIOUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.FileUtils;
import org.springframework.util.Assert;

public abstract class StoredFile
extends StoredResource
implements File {
    private static final String FOLDER_NULL_MESSAGE = "Folder must not be null";
    private final StoredFileContent content = new StoredFileContent();

    @Override
    protected abstract FileStore getStore();

    @Override
    public long getSize() {
        return this.getStore().getSize();
    }

    @Override
    public long getLastModified() {
        return this.getStore().getLastModified();
    }

    @Override
    public void touch() {
        this.ensureExists();
        this.getStore().touch();
    }

    @Override
    public FileContent getContent() {
        return this.content;
    }

    @Override
    public File rename(String name) {
        return (File)super.rename(name);
    }

    @Override
    public void delete() {
        if (this.exists()) {
            this.getStore().delete();
        }
    }

    @Override
    public File moveTo(Folder folder) {
        Assert.notNull((Object)folder, (String)FOLDER_NULL_MESSAGE);
        this.ensureExists();
        File destination = folder.getFile(this.getName());
        if (destination.exists()) {
            destination.delete();
        }
        try {
            FileUtils.moveFile((java.io.File)WMIOUtils.getJavaIOFile(this), (java.io.File)WMIOUtils.getJavaIOFile(destination));
        }
        catch (IOException e) {
            throw new ResourceException(e);
        }
        return destination;
    }

    @Override
    public File copyTo(Folder folder) {
        Assert.notNull((Object)folder, (String)FOLDER_NULL_MESSAGE);
        this.ensureExists();
        File destination = folder.getFile(this.getName());
        destination.getContent().write(this);
        return destination;
    }

    @Override
    public File copyToIfNewer(Folder folder) {
        Assert.notNull((Object)folder, (String)FOLDER_NULL_MESSAGE);
        this.ensureExists();
        File destination = folder.getFile(this.getName());
        if (!destination.exists() || this.isModifiedAfter(destination)) {
            destination.getContent().write(this);
            return destination;
        }
        return null;
    }

    @Override
    public void createIfMissing() {
        if (!this.exists()) {
            this.createParentIfMissing();
            try {
                this.getStore().create();
            }
            catch (ResourceAlreadyExistException resourceAlreadyExistException) {
                // empty catch block
            }
        }
    }

    protected boolean write(File file) {
        return false;
    }

    private class StoredFileContent
    extends AbstractFileContent {
        private StoredFileContent() {
        }

        @Override
        public InputStream asInputStream() {
            return StoredFile.this.getStore().getInputStream();
        }

        @Override
        public OutputStream asOutputStream() {
            return this.asOutputStream(false);
        }

        @Override
        public OutputStream asOutputStream(boolean append) {
            StoredFile.this.createParentIfMissing();
            return StoredFile.this.getStore().getOutputStream(append);
        }

        @Override
        public void write(File file) {
            StoredFile.this.createParentIfMissing();
            if (!StoredFile.this.write(file)) {
                super.write(file);
            }
        }
    }
}

