/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.commons.json.deserializer;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.wavemaker.commons.MessageResource;
import com.wavemaker.commons.WMRuntimeException;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import org.apache.commons.lang3.StringUtils;

public class WMLocalDateTimeDeSerializer
extends JsonDeserializer<LocalDateTime> {
    private static final DateTimeFormatter parser = DateTimeFormatter.ISO_LOCAL_DATE_TIME;

    public LocalDateTime deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        JsonToken currentToken = jsonParser.getCurrentToken();
        if (currentToken == JsonToken.VALUE_STRING) {
            String value = jsonParser.getText();
            return WMLocalDateTimeDeSerializer.getLocalDateTime(value);
        }
        throw new WMRuntimeException(MessageResource.create("com.wavemaker.commons.not.a.string.value"));
    }

    public static LocalDateTime getLocalDateTime(String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return null;
        }
        return LocalDateTime.parse(value, parser);
    }
}

