/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.commons.json.deserializer;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.wavemaker.commons.MessageResource;
import com.wavemaker.commons.WMRuntimeException;
import java.io.IOException;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import org.apache.commons.lang3.StringUtils;

public class WMLocalTimeDeserializer
extends JsonDeserializer<LocalTime> {
    private static final DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("HH:mm:ss");

    public LocalTime deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        JsonToken currentToken = jsonParser.getCurrentToken();
        if (currentToken == JsonToken.VALUE_STRING) {
            String value = jsonParser.getText();
            return WMLocalTimeDeserializer.getLocalDateTime(value);
        }
        throw new WMRuntimeException(MessageResource.create("com.wavemaker.commons.not.a.string.value"));
    }

    public static LocalTime getLocalDateTime(String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return null;
        }
        return LocalTime.parse(value, dateTimeFormatter);
    }
}

