/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.commons.json.deserializer;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.wavemaker.commons.MessageResource;
import com.wavemaker.commons.WMRuntimeException;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;

public class WMSqlDateDeSerializer
extends JsonDeserializer<java.sql.Date> {
    private static final String DEFAULT_DATE_FORMAT = "yyyy-MM-dd";

    public java.sql.Date deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        JsonToken currentToken = jsonParser.getCurrentToken();
        if (currentToken == JsonToken.VALUE_STRING) {
            String value = jsonParser.getText();
            return WMSqlDateDeSerializer.getDate(value);
        }
        throw new WMRuntimeException(MessageResource.create("com.wavemaker.commons.failed.to.read.token.as.java.sql.Date"));
    }

    public static java.sql.Date getDate(String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return null;
        }
        try {
            Date parsedDate = new SimpleDateFormat(DEFAULT_DATE_FORMAT).parse(value);
            return new java.sql.Date(parsedDate.getTime());
        }
        catch (ParseException e) {
            throw new WMRuntimeException(MessageResource.create("com.wavemaker.commons.string.to.date.parse.failure"), (Throwable)e, value, "java.sql.Date");
        }
    }
}

