/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.commons.processor;

import com.wavemaker.commons.processor.ArrayEntryObjectInfo;
import com.wavemaker.commons.processor.ChildObjectRetriever;
import com.wavemaker.commons.processor.FieldObjectInfo;
import com.wavemaker.commons.processor.ListEntryObjectInfo;
import com.wavemaker.commons.processor.MapEntryKeyObjectInfo;
import com.wavemaker.commons.processor.MapEntryValueObjectInfo;
import com.wavemaker.commons.processor.ObjectInfo;
import com.wavemaker.commons.processor.SetEntryObjectInfo;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ReflectionUtils;

public class DefaultChildObjectRetriever
implements ChildObjectRetriever {
    private static final Logger logger = LoggerFactory.getLogger(DefaultChildObjectRetriever.class);
    private final Predicate<Field> fieldPredicate;

    public DefaultChildObjectRetriever() {
        this.fieldPredicate = field -> true;
    }

    public DefaultChildObjectRetriever(Predicate<Field> fieldPredicate) {
        this.fieldPredicate = fieldPredicate;
    }

    @Override
    public List<ObjectInfo> getChildObjects(ObjectInfo objectInfo) {
        Object object = objectInfo.getObject();
        ArrayList<ObjectInfo> childObjectsInfo = new ArrayList<ObjectInfo>();
        if (object instanceof List) {
            this.processList((List)object, objectInfo, childObjectsInfo);
        } else if (object instanceof Map) {
            this.processMap((Map)object, objectInfo, childObjectsInfo);
        } else if (object instanceof Set) {
            this.processSet((Set)object, objectInfo, childObjectsInfo);
        } else if (object.getClass().isArray()) {
            this.processArray(object, objectInfo, childObjectsInfo);
        } else if (object.getClass().getClassLoader() != null) {
            this.processCustomObject(object, objectInfo, childObjectsInfo);
        }
        return childObjectsInfo;
    }

    private void processList(List list, ObjectInfo parentObjectInfo, List<ObjectInfo> childObjectsInfo) {
        try {
            for (int index = 0; index < list.size(); ++index) {
                ListEntryObjectInfo childObjectInfo = new ListEntryObjectInfo(list.get(index), parentObjectInfo, index);
                childObjectsInfo.add(childObjectInfo);
            }
        }
        catch (Exception e) {
            logger.debug("Failed to retrieve elements of a list of class {}", list.getClass(), (Object)e);
        }
    }

    private void processMap(Map map, ObjectInfo parentObjectInfo, List<ObjectInfo> childObjectsInfo) {
        try {
            map.forEach((k, v) -> {
                MapEntryKeyObjectInfo mapEntryKeyObjectInfo = new MapEntryKeyObjectInfo(k, v, parentObjectInfo);
                MapEntryValueObjectInfo mapEntryValueObjectInfo = new MapEntryValueObjectInfo(mapEntryKeyObjectInfo, v, parentObjectInfo);
                childObjectsInfo.add(mapEntryKeyObjectInfo);
                childObjectsInfo.add(mapEntryValueObjectInfo);
            });
        }
        catch (Exception e) {
            logger.debug("Failed to retrieve elements of a map", (Throwable)e);
        }
    }

    private void processSet(Set set, ObjectInfo parentObjectInfo, List<ObjectInfo> childObjectsInfo) {
        try {
            set.forEach(setElement -> {
                SetEntryObjectInfo setEntryObjectInfo = new SetEntryObjectInfo(setElement, parentObjectInfo);
                childObjectsInfo.add(setEntryObjectInfo);
            });
        }
        catch (Exception e) {
            logger.debug("Failed to retrieve elements of a set", (Throwable)e);
        }
    }

    private void processArray(Object object, ObjectInfo parentObjectInfo, List<ObjectInfo> childObjectsInfo) {
        try {
            for (int index = 0; index < Array.getLength(object); ++index) {
                ArrayEntryObjectInfo arrayEntryObjectInfo = new ArrayEntryObjectInfo(Array.get(object, index), parentObjectInfo, index);
                childObjectsInfo.add(arrayEntryObjectInfo);
            }
        }
        catch (Exception e) {
            logger.debug("Failed to retrieve elements of a array", (Throwable)e);
        }
    }

    private void processCustomObject(Object object, ObjectInfo parentObjectInfo, List<ObjectInfo> childObjectsInfo) {
        ReflectionUtils.doWithFields(object.getClass(), field -> {
            if (this.fieldPredicate.test(field) && !Modifier.isStatic(field.getModifiers())) {
                try {
                    ReflectionUtils.makeAccessible((Field)field);
                    Object o = ReflectionUtils.getField((Field)field, (Object)object);
                    FieldObjectInfo fieldObjectInfo = new FieldObjectInfo(o, parentObjectInfo, field);
                    childObjectsInfo.add(fieldObjectInfo);
                }
                catch (Exception e) {
                    logger.debug("Cannot access object from the field {} in class {}", (Object)field.getName(), (Object)field.getDeclaringClass().getName());
                }
            }
        });
    }
}

