/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.commons.processor;

import com.wavemaker.commons.processor.ChildObjectRetriever;
import com.wavemaker.commons.processor.ObjectInfo;
import com.wavemaker.commons.processor.ObjectProcessor;
import com.wavemaker.commons.processor.ProcessContext;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.commons.lang3.ClassUtils;

public class RecursiveObjectProcessor {
    private final ObjectProcessor objectProcessor;
    private final ChildObjectRetriever childObjectRetriever;
    private final ProcessContext processContext;
    private final Predicate<Object> objectPredicate;

    public RecursiveObjectProcessor(ObjectProcessor objectProcessor, ChildObjectRetriever childObjectRetriever, ProcessContext processContext) {
        this(objectProcessor, childObjectRetriever, processContext, aClass -> true);
    }

    public RecursiveObjectProcessor(ObjectProcessor objectProcessor, ChildObjectRetriever childObjectRetriever, ProcessContext processContext, Predicate<Object> objectPredicate) {
        this.objectProcessor = objectProcessor;
        this.childObjectRetriever = childObjectRetriever;
        this.processContext = processContext;
        this.objectPredicate = objectPredicate;
    }

    public Object processRootObject(Object object) {
        ObjectInfo objectInfo = new ObjectInfo(object, null);
        this.processObject(objectInfo, this.processContext.getKnownObjects());
        return objectInfo.getObject();
    }

    private void processObject(ObjectInfo objectInfo, Set<Object> knownObjects) {
        Object object = objectInfo.getObject();
        if (object != null && this.objectPredicate.test(object)) {
            if (ClassUtils.isPrimitiveOrWrapper(object.getClass()) || object instanceof String) {
                this.objectProcessor.processObject(objectInfo);
            } else if (!knownObjects.contains(object)) {
                knownObjects.add(object);
                this.objectProcessor.processObject(objectInfo);
                this.processChildObjects(objectInfo, knownObjects);
            }
        }
    }

    private void processChildObjects(ObjectInfo objectInfo, Set<Object> knownObjects) {
        List<ObjectInfo> childObjectsInfo = this.childObjectRetriever.getChildObjects(objectInfo);
        for (ObjectInfo childObjectInfo : childObjectsInfo) {
            this.processObject(childObjectInfo, knownObjects);
        }
    }
}

