/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.commons.util;

import com.wavemaker.commons.pattern.URLPattern;
import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class CoreFilterUtil {
    private CoreFilterUtil() {
    }

    public static List<URLPattern> extractExcludedUrlsList(String excludedUrls) {
        ArrayList<URLPattern> excludedUrlsList = new ArrayList<URLPattern>();
        if (excludedUrls != null) {
            StringTokenizer tokenizer = new StringTokenizer(excludedUrls, ";");
            while (tokenizer.hasMoreTokens()) {
                excludedUrlsList.add(URLPattern.constructPattern(tokenizer.nextToken().trim()));
            }
        }
        return excludedUrlsList;
    }

    public static boolean isExcluded(HttpServletRequest request, List<URLPattern> excludedUrls) {
        if (excludedUrls != null && !excludedUrls.isEmpty()) {
            String requestUri = request.getRequestURI();
            String requestPath = requestUri.substring(request.getContextPath().length());
            for (URLPattern urlPattern : excludedUrls) {
                if (!urlPattern.matches(requestPath)) continue;
                return true;
            }
        }
        return false;
    }
}

