/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.commons.util;

import com.wavemaker.commons.util.WMIOUtils;
import com.wavemaker.commons.util.XMLUtils;
import com.wavemaker.commons.util.XmlDocument;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class JAXBUtils {
    private static final String JAXB_ENCODING = "UTF-8";

    private JAXBUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> XmlDocument<T> unMarshall(JAXBContext context, InputStream inputStream) throws JAXBException, IOException, SAXException, ParserConfigurationException {
        XmlDocument<Object> xmlDocument;
        Unmarshaller unmarshaller = null;
        try {
            Document document = XMLUtils.readDocument(inputStream);
            unmarshaller = context.createUnmarshaller();
            Object t = unmarshaller.unmarshal((Node)document);
            xmlDocument = new XmlDocument<Object>(document, t);
        }
        catch (Throwable throwable) {
            JAXBUtils.closeResources(inputStream, unmarshaller);
            throw throwable;
        }
        JAXBUtils.closeResources(inputStream, unmarshaller);
        return xmlDocument;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void marshall(JAXBContext context, OutputStream outputStream, Object object) throws JAXBException {
        Marshaller marshaller = null;
        try {
            marshaller = context.createMarshaller();
            marshaller.setProperty("jaxb.encoding", (Object)JAXB_ENCODING);
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            marshaller.marshal(object, outputStream);
        }
        finally {
            JAXBUtils.closeResources(outputStream, null);
        }
    }

    public static JAXBContext getJAXBContext(String packagePrefix) throws JAXBException {
        return JAXBContext.newInstance((String)packagePrefix);
    }

    private static void closeResources(AutoCloseable resourceStream, Unmarshaller unmarshaller) {
        WMIOUtils.closeByLogging(resourceStream);
        if (unmarshaller != null && unmarshaller instanceof AutoCloseable) {
            WMIOUtils.closeByLogging((AutoCloseable)unmarshaller);
        }
    }
}

