/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.commons.util;

import com.wavemaker.commons.json.deserializer.WMDateDeSerializer;
import com.wavemaker.commons.json.deserializer.WMLocalDateTimeDeSerializer;
import com.wavemaker.commons.util.ObjectLiteralParser;
import com.wavemaker.commons.util.StringUtils;
import com.wavemaker.commons.wrapper.BooleanWrapper;
import com.wavemaker.commons.wrapper.ByteWrapper;
import com.wavemaker.commons.wrapper.CharacterWrapper;
import com.wavemaker.commons.wrapper.DateWrapper;
import com.wavemaker.commons.wrapper.DoubleWrapper;
import com.wavemaker.commons.wrapper.FloatWrapper;
import com.wavemaker.commons.wrapper.IntegerWrapper;
import com.wavemaker.commons.wrapper.LongWrapper;
import com.wavemaker.commons.wrapper.ShortWrapper;
import com.wavemaker.commons.wrapper.StringWrapper;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class TypeConversionUtils {
    private static final Map<String, Class<?>> PRIMITIVES = new HashMap(8);
    private static final Collection<Class<?>> PRIMITIVE_WRAPPERS = new HashSet(11);
    private static final Map<String, Class<?>> PRIMITIVE_ARRAYS = new HashMap(11);
    private static final Map<String, Class<?>> WM_PRIMITIVE_WRAPPERS = new HashMap(8);
    private static final Set<String> PRIMITIVE_DATA_TYPES = new HashSet<String>();
    private static final Set<String> SERVLET_CLASSES = new HashSet<String>();

    private TypeConversionUtils() {
    }

    public static boolean isServletClass(String className) {
        return SERVLET_CLASSES.contains(className);
    }

    public static boolean isPrimitive(String dataType) {
        return PRIMITIVE_DATA_TYPES.contains(dataType);
    }

    public static Class<?> primitiveForName(String className) {
        return PRIMITIVES.get(className);
    }

    public static Class<?> primitiveArraysForName(String className) {
        return PRIMITIVE_ARRAYS.get(className);
    }

    public static String checkAndReturnForMultiDimensionalArrays(String className) {
        Pattern pattern = Pattern.compile("(\\[)*[L][\\w\\W]*");
        Matcher matcher = pattern.matcher(className);
        if (matcher.matches()) {
            return className.replaceFirst("(\\[)*[L]", "");
        }
        return null;
    }

    public static boolean checkPrimitiveAndPrimitiveArrays(String className) {
        return TypeConversionUtils.primitiveArraysForName(className) == null && TypeConversionUtils.primitiveForName(className) == null;
    }

    public static Class<?> primitiveWrapperClassByName(String className) {
        for (Class<?> klass : PRIMITIVE_WRAPPERS) {
            if (!klass.getSimpleName().equals(className)) continue;
            return klass;
        }
        return null;
    }

    public static Class<?> wmPrimitiveWrapperClassByName(String className) {
        return WM_PRIMITIVE_WRAPPERS.get(className);
    }

    public static boolean isPrimitiveOrEnum(Type type) {
        if (type instanceof Class) {
            Class klass = (Class)type;
            if (!((Class)type).isArray() && (TypeConversionUtils.isPrimitive(klass.getName()) || klass.isEnum())) {
                return true;
            }
        }
        return false;
    }

    public static boolean isPrimitiveOrWrapper(Class<?> clazz) {
        if (clazz.isPrimitive()) {
            return true;
        }
        if (clazz.equals(String.class)) {
            return true;
        }
        if (java.util.Date.class.isAssignableFrom(clazz)) {
            return true;
        }
        if (LocalDateTime.class.isAssignableFrom(clazz)) {
            return true;
        }
        return PRIMITIVE_WRAPPERS.contains(clazz);
    }

    public static boolean isArray(Class<?> clazz) {
        return clazz != null && (Collection.class.isAssignableFrom(clazz) || clazz.isArray());
    }

    public static boolean isMap(Class<?> clazz) {
        return clazz != null && Map.class.isAssignableFrom(clazz);
    }

    public static Object fromString(Class<?> type, String s) {
        return TypeConversionUtils.fromString(type, s, false);
    }

    public static Object fromString(Class<?> type, String s, boolean isList) {
        if (isList || !TypeConversionUtils.isPrimitiveOrWrapper(type)) {
            if (s == null) {
                return null;
            }
            ObjectLiteralParser p = new ObjectLiteralParser(s, type);
            return p.parse();
        }
        if (s == null) {
            return null;
        }
        if (type == AtomicInteger.class) {
            return null;
        }
        if (type == AtomicLong.class) {
            return null;
        }
        if (type == BigDecimal.class) {
            return new BigDecimal(s);
        }
        if (type == BigInteger.class) {
            return new BigDecimal(s);
        }
        if (type == Boolean.class || type == Boolean.TYPE) {
            return Boolean.valueOf(s);
        }
        if (type == Byte.class || type == Byte.TYPE) {
            return Byte.valueOf(s);
        }
        if (type == java.util.Date.class) {
            if (StringUtils.isNumber(s)) {
                return new java.util.Date(Long.parseLong(s));
            }
            throw new IllegalArgumentException("Unable to convert " + s + " to " + java.util.Date.class.getName());
        }
        if (type == Date.class) {
            return WMDateDeSerializer.getDate(s);
        }
        if (type == Time.class) {
            return WMDateDeSerializer.getDate(s);
        }
        if (type == Timestamp.class) {
            if (StringUtils.isNumber(s)) {
                return new Timestamp(Long.parseLong(s));
            }
            throw new IllegalArgumentException("Unable to convert " + s + " to " + Timestamp.class.getName());
        }
        if (type == LocalDateTime.class) {
            return WMLocalDateTimeDeSerializer.getLocalDateTime(s);
        }
        if (type == Double.class || type == Double.TYPE) {
            return Double.valueOf(s);
        }
        if (type == Float.class || type == Float.TYPE) {
            return Float.valueOf(s);
        }
        if (type == Integer.class || type == Integer.TYPE) {
            return Integer.valueOf(s);
        }
        if (type == Long.class || type == Long.TYPE) {
            return Long.valueOf(s);
        }
        if (type == Short.class || type == Short.TYPE) {
            return Short.valueOf(s);
        }
        if (type == String.class || type == StringBuffer.class) {
            return s;
        }
        if (type == Character.class || type == Character.TYPE) {
            return Character.valueOf(s.charAt(0));
        }
        throw new AssertionError((Object)("Unable to convert \"" + s + "\" to " + String.valueOf(type) + " - unknown type: " + String.valueOf(type)));
    }

    public static String getValueString(Class<?> type, String s) {
        if (s == null) {
            return "null";
        }
        if (type == String.class || type == StringBuffer.class) {
            return "'" + s + "'";
        }
        if (type == java.util.Date.class || type == Date.class || type == Timestamp.class || type == Time.class) {
            return "'" + s + "'";
        }
        return s;
    }

    public static boolean primitivesMatch(Class<?> p1, Class<?> p2) {
        if (!p1.isPrimitive() && !p2.isPrimitive()) {
            return false;
        }
        if (TypeConversionUtils.compare(p1, p2, Boolean.class, Boolean.TYPE)) {
            return true;
        }
        if (TypeConversionUtils.compare(p1, p2, Byte.class, Byte.TYPE)) {
            return true;
        }
        if (TypeConversionUtils.compare(p1, p2, Double.class, Double.TYPE)) {
            return true;
        }
        if (TypeConversionUtils.compare(p1, p2, Float.class, Float.TYPE)) {
            return true;
        }
        if (TypeConversionUtils.compare(p1, p2, Integer.class, Integer.TYPE)) {
            return true;
        }
        if (TypeConversionUtils.compare(p1, p2, Long.class, Long.TYPE)) {
            return true;
        }
        if (TypeConversionUtils.compare(p1, p2, Short.class, Short.TYPE)) {
            return true;
        }
        return TypeConversionUtils.compare(p1, p2, Character.class, Character.TYPE);
    }

    private static boolean compare(Class<?> p1, Class<?> p2, Class<?> t1, Class<?> t2) {
        if (p1 == t1 && p2 == t2) {
            return true;
        }
        return p1 == t2 && p2 == t1;
    }

    static {
        PRIMITIVES.put(Boolean.TYPE.getName(), Boolean.TYPE);
        PRIMITIVES.put(Byte.TYPE.getName(), Byte.TYPE);
        PRIMITIVES.put(Character.TYPE.getName(), Character.TYPE);
        PRIMITIVES.put(Double.TYPE.getName(), Double.TYPE);
        PRIMITIVES.put(Float.TYPE.getName(), Float.TYPE);
        PRIMITIVES.put(Integer.TYPE.getName(), Integer.TYPE);
        PRIMITIVES.put(Long.TYPE.getName(), Long.TYPE);
        PRIMITIVES.put(Short.TYPE.getName(), Short.TYPE);
        WM_PRIMITIVE_WRAPPERS.put(Boolean.TYPE.getName(), BooleanWrapper.class);
        WM_PRIMITIVE_WRAPPERS.put(Boolean.class.getName(), BooleanWrapper.class);
        WM_PRIMITIVE_WRAPPERS.put(Byte.TYPE.getName(), ByteWrapper.class);
        WM_PRIMITIVE_WRAPPERS.put(Byte.class.getName(), ByteWrapper.class);
        WM_PRIMITIVE_WRAPPERS.put(Character.TYPE.getName(), CharacterWrapper.class);
        WM_PRIMITIVE_WRAPPERS.put(Character.class.getName(), CharacterWrapper.class);
        WM_PRIMITIVE_WRAPPERS.put(Double.TYPE.getName(), DoubleWrapper.class);
        WM_PRIMITIVE_WRAPPERS.put(Double.class.getName(), DoubleWrapper.class);
        WM_PRIMITIVE_WRAPPERS.put(Float.TYPE.getName(), FloatWrapper.class);
        WM_PRIMITIVE_WRAPPERS.put(Float.class.getName(), FloatWrapper.class);
        WM_PRIMITIVE_WRAPPERS.put(Integer.TYPE.getName(), IntegerWrapper.class);
        WM_PRIMITIVE_WRAPPERS.put(Integer.class.getName(), IntegerWrapper.class);
        WM_PRIMITIVE_WRAPPERS.put(Long.TYPE.getName(), LongWrapper.class);
        WM_PRIMITIVE_WRAPPERS.put(Long.class.getName(), LongWrapper.class);
        WM_PRIMITIVE_WRAPPERS.put(Short.TYPE.getName(), ShortWrapper.class);
        WM_PRIMITIVE_WRAPPERS.put(Short.class.getName(), ShortWrapper.class);
        WM_PRIMITIVE_WRAPPERS.put("String", StringWrapper.class);
        WM_PRIMITIVE_WRAPPERS.put(String.class.getName(), StringWrapper.class);
        WM_PRIMITIVE_WRAPPERS.put("Date", DateWrapper.class);
        WM_PRIMITIVE_WRAPPERS.put(java.util.Date.class.getName(), DateWrapper.class);
        PRIMITIVE_ARRAYS.put(boolean[].class.getName(), boolean[].class);
        PRIMITIVE_ARRAYS.put(byte[].class.getName(), byte[].class);
        PRIMITIVE_ARRAYS.put(char[].class.getName(), char[].class);
        PRIMITIVE_ARRAYS.put(double[].class.getName(), double[].class);
        PRIMITIVE_ARRAYS.put(float[].class.getName(), float[].class);
        PRIMITIVE_ARRAYS.put(int[].class.getName(), int[].class);
        PRIMITIVE_ARRAYS.put(long[].class.getName(), long[].class);
        PRIMITIVE_ARRAYS.put(short[].class.getName(), short[].class);
        PRIMITIVE_WRAPPERS.add(AtomicInteger.class);
        PRIMITIVE_WRAPPERS.add(AtomicLong.class);
        PRIMITIVE_WRAPPERS.add(BigDecimal.class);
        PRIMITIVE_WRAPPERS.add(BigInteger.class);
        PRIMITIVE_WRAPPERS.add(Boolean.class);
        PRIMITIVE_WRAPPERS.add(Byte.class);
        PRIMITIVE_WRAPPERS.add(Character.class);
        PRIMITIVE_WRAPPERS.add(Double.class);
        PRIMITIVE_WRAPPERS.add(Float.class);
        PRIMITIVE_WRAPPERS.add(Integer.class);
        PRIMITIVE_WRAPPERS.add(Long.class);
        PRIMITIVE_WRAPPERS.add(Short.class);
        PRIMITIVE_DATA_TYPES.add("int");
        PRIMITIVE_DATA_TYPES.add("Integer");
        PRIMITIVE_DATA_TYPES.add("java.lang.Integer");
        PRIMITIVE_DATA_TYPES.add("String");
        PRIMITIVE_DATA_TYPES.add("java.lang.String");
        PRIMITIVE_DATA_TYPES.add("float");
        PRIMITIVE_DATA_TYPES.add("Float");
        PRIMITIVE_DATA_TYPES.add("java.lang.Float");
        PRIMITIVE_DATA_TYPES.add("boolean");
        PRIMITIVE_DATA_TYPES.add("Boolean");
        PRIMITIVE_DATA_TYPES.add("java.lang.Boolean");
        PRIMITIVE_DATA_TYPES.add("char");
        PRIMITIVE_DATA_TYPES.add("Character");
        PRIMITIVE_DATA_TYPES.add("java.lang.Character");
        PRIMITIVE_DATA_TYPES.add("byte");
        PRIMITIVE_DATA_TYPES.add("Byte");
        PRIMITIVE_DATA_TYPES.add("java.lang.Byte");
        PRIMITIVE_DATA_TYPES.add("short");
        PRIMITIVE_DATA_TYPES.add("Short");
        PRIMITIVE_DATA_TYPES.add("java.lang.Short");
        PRIMITIVE_DATA_TYPES.add("long");
        PRIMITIVE_DATA_TYPES.add("Long");
        PRIMITIVE_DATA_TYPES.add("java.lang.Long");
        PRIMITIVE_DATA_TYPES.add("double");
        PRIMITIVE_DATA_TYPES.add("Double");
        PRIMITIVE_DATA_TYPES.add("java.lang.Double");
        PRIMITIVE_DATA_TYPES.add("Date");
        PRIMITIVE_DATA_TYPES.add("java.util.Date");
        PRIMITIVE_DATA_TYPES.add("java.math.BigDecimal");
        PRIMITIVE_DATA_TYPES.add("java.math.BigInteger");
        PRIMITIVE_DATA_TYPES.add("java.sql.Timestamp");
        PRIMITIVE_DATA_TYPES.add("java.sql.Time");
        PRIMITIVE_DATA_TYPES.add("java.sql.Date");
        PRIMITIVE_DATA_TYPES.add("org.springframework.data.domain.Pageable");
        SERVLET_CLASSES.add("ServletContext");
        SERVLET_CLASSES.add("HttpServletRequest");
        SERVLET_CLASSES.add("HttpServletResponse");
        SERVLET_CLASSES.add("HttpSession");
        SERVLET_CLASSES.add("MultipartHttpServletRequest");
        SERVLET_CLASSES.add("jakarta.servlet.ServletContext");
        SERVLET_CLASSES.add("jakarta.servlet.http.HttpServletRequest");
        SERVLET_CLASSES.add("jakarta.servlet.http.HttpServletResponse");
        SERVLET_CLASSES.add("jakarta.servlet.http.HttpSession");
        SERVLET_CLASSES.add("org.springframework.web.multipart.MultipartHttpServletRequest");
    }
}

