/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.commons.util;

import com.wavemaker.commons.MessageResource;
import com.wavemaker.commons.WMRuntimeException;
import com.wavemaker.commons.io.Resource;
import com.wavemaker.commons.util.FilePatternMatchVisitor;
import com.wavemaker.commons.util.WMIOUtils;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.io.FileUtils;

public class WMFileUtils {
    private WMFileUtils() {
    }

    public static String readFileToString(File file) throws IOException {
        return FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8);
    }

    public static void writeStringToFile(File file, String data) throws IOException {
        FileUtils.writeStringToFile((File)file, (String)data, (Charset)StandardCharsets.UTF_8, (boolean)false);
    }

    public static Collection<String> findMatchedRelativePaths(String pattern, String basePath) {
        FilePatternMatchVisitor filePatternMatchVisitor = new FilePatternMatchVisitor(pattern, basePath);
        try {
            Files.walkFileTree(Paths.get(basePath, new String[0]), filePatternMatchVisitor);
            Collection<Path> matchedFiles = filePatternMatchVisitor.getMatchedPaths();
            ArrayList<String> matchedFilePaths = new ArrayList<String>(matchedFiles.size());
            for (Path path : matchedFiles) {
                matchedFilePaths.add(path.toString());
            }
            return matchedFilePaths;
        }
        catch (IOException e) {
            throw new WMRuntimeException(MessageResource.create("com.wavemaker.commons.failed.to.find.matched.ignore.patterns"), (Throwable)e, pattern);
        }
    }

    public static boolean isExists(Resource resource) {
        return resource != null && resource.exists();
    }

    public static void renameFile(Resource resource, String newFileName) {
        Path path = WMIOUtils.getJavaIOFile(resource).toPath();
        try {
            Files.move(path, path.resolveSibling(newFileName), new CopyOption[0]);
        }
        catch (IOException e) {
            throw new WMRuntimeException(MessageResource.create("com.wavemaker.commons.failed.to.rename.file"), (Throwable)e, resource.getName());
        }
    }
}

