/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.commons.util;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.lang3.StringEscapeUtils;

public class XMLWriter {
    private static final String SEPARATOR = "\n";
    private static final int DEFAULT_INDENT = 2;
    private static final int DEFAULT_MAX_ATTRS_ON_SAME_LINE = 2;
    private int startIndent;
    private static final String ENCODING = "utf-8";
    private String currentShortNS;
    private boolean wroteFirstElement;
    private boolean hasElements;
    private boolean incompleteOpenTag;
    private boolean hasAttributes;
    private final SortedMap<String, String> namespaces = new TreeMap<String, String>();
    private boolean closeOnNewLine;
    private final Stack elementStack = new Stack();
    private final PrintWriter pw;
    private final int indent;
    private final int maxAttrsOnSameLine;
    private boolean textOnSameLineAsParentElement = true;

    public XMLWriter(PrintWriter pw) {
        this(pw, 2);
    }

    public XMLWriter(PrintWriter pw, int indent) {
        this(pw, indent, 2);
    }

    public XMLWriter(PrintWriter pw, int indent, int maxAttrsOnSameLine) {
        this.indent = indent;
        this.maxAttrsOnSameLine = maxAttrsOnSameLine;
        this.pw = pw;
    }

    public void flush() {
        this.pw.flush();
    }

    public void addDoctype(String doctypeName, String publicID, String systemID) {
        if (this.hasElements) {
            throw new MalformedXMLRuntimeException("Cannot init document after elements have been added");
        }
        StringBuilder dtdString = new StringBuilder();
        dtdString.append("<!DOCTYPE ").append(doctypeName);
        if (publicID != null) {
            dtdString.append(" PUBLIC \"").append(publicID).append("\"");
        }
        if (systemID != null && publicID == null) {
            dtdString.append(" SYSTEM");
        }
        dtdString.append(" \"").append(systemID).append("\"");
        dtdString.append(">").append(SEPARATOR);
        this.writeGeneric(dtdString.toString());
    }

    public void addVersion() {
        this.addVersion(false);
    }

    public void addVersion(boolean standalone) {
        if (this.hasElements) {
            throw new MalformedXMLRuntimeException("Cannot write version after elements have been added");
        }
        this.pw.print("<?xml version=\"1.0\" encoding=\"utf-8\"");
        if (standalone) {
            this.pw.print(" standalone=\"yes\"");
        }
        this.pw.print("?>");
        this.pw.print(SEPARATOR);
    }

    public void setCurrentShortNS(String s) {
        if (!this.namespaces.containsKey(s)) {
            throw new MalformedXMLRuntimeException("Short NS \"" + s + "\" has not been declared.  Known short NS: " + String.valueOf(this.namespaces.keySet()));
        }
        this.currentShortNS = s;
    }

    public void unsetCurrentShortNS() {
        this.currentShortNS = null;
    }

    public void forceCloseOnNewLine() {
        this.closeOnNewLine = true;
    }

    public boolean willCloseOnNewLine() {
        return this.closeOnNewLine;
    }

    public void setStartIndent(int startIndent) {
        this.startIndent = startIndent;
    }

    public void setTextOnSameLineAsParentElement(boolean b) {
        this.textOnSameLineAsParentElement = b;
    }

    public void addNamespace(String shortNS, String longNS) {
        this.namespaces.put(shortNS, longNS);
    }

    public void addComment(String comment) {
        StringBuilder sb = new StringBuilder();
        if (this.hasElements) {
            this.finishIncompleteTag();
            sb.append(SEPARATOR);
        }
        sb.append(this.getIndent()).append("<!-- ").append(comment).append(" -->");
        if (!this.hasElements) {
            sb.append(SEPARATOR);
        }
        this.writeGeneric(sb.toString());
    }

    public void addAttribute(String name, String value) {
        if (!this.incompleteOpenTag) {
            throw new MalformedXMLRuntimeException("Illegal call to addAttribute");
        }
        this.hasAttributes = true;
        if (this.closeOnNewLine) {
            this.pw.print(SEPARATOR);
            this.pw.print(this.getIndent());
        } else {
            this.pw.print(" ");
        }
        this.pw.print(name);
        this.pw.print("=\"");
        this.pw.print(value);
        this.pw.print("\"");
    }

    public void addAttribute(Map<String, String> attributes) {
        String[] attributesArray = new String[attributes.size() * 2];
        int index = 0;
        for (Map.Entry<String, String> entry : attributes.entrySet()) {
            attributesArray[index] = entry.getKey();
            attributesArray[index + 1] = entry.getValue();
            index += 2;
        }
        this.addAttribute(attributesArray);
    }

    public void addAttribute(String ... attributes) {
        if (!this.hasAttributes && attributes.length / 2 > this.maxAttrsOnSameLine) {
            this.closeOnNewLine = true;
        }
        for (int i = 0; i < attributes.length; i += 2) {
            String key = attributes[i];
            String value = attributes[i + 1];
            this.addAttribute(key, value);
        }
    }

    public void addNestedElements(String ... elementNames) {
        for (String elementName : elementNames) {
            this.addElement(elementName);
        }
    }

    public void addClosedElements(String ... elementNames) {
        for (String elementName : elementNames) {
            this.addClosedElement(elementName);
        }
    }

    public void addClosedElement(String elementName) {
        this.addElement(elementName);
        this.closeElement();
    }

    public void addClosedElement(String elementName, String ... attributes) {
        this.addElement(elementName, attributes);
        this.closeElement();
    }

    public void addElement(String elementName) {
        boolean addNamespaces;
        this.hasElements = true;
        this.finishIncompleteTag();
        boolean bl = addNamespaces = !this.wroteFirstElement;
        if (this.wroteFirstElement) {
            this.pw.print(SEPARATOR);
        } else {
            this.wroteFirstElement = true;
        }
        this.pw.print(this.getIndent());
        this.pw.print("<");
        if (this.currentShortNS != null) {
            elementName = this.qualify(elementName, this.currentShortNS);
        }
        this.pw.print(elementName);
        this.elementStack.push(elementName);
        this.incompleteOpenTag = true;
        this.hasAttributes = false;
        this.closeOnNewLine = false;
        if (addNamespaces && !this.namespaces.isEmpty()) {
            String[] ns = new String[this.namespaces.size() * 2];
            int i = 0;
            for (Map.Entry<String, String> e : this.namespaces.entrySet()) {
                ns[i] = this.qualify(e.getKey(), "xmlns");
                ns[i + 1] = e.getValue();
                i += 2;
            }
            this.closeOnNewLine = true;
            this.addAttribute(ns);
        }
    }

    public void addElement(String elementName, String textChild) {
        this.addElement(elementName);
        this.addText(textChild, !this.textOnSameLineAsParentElement);
        this.closeElement(!this.textOnSameLineAsParentElement);
    }

    public void addElement(String elementName, String ... attributes) {
        this.addElement(elementName);
        this.addAttribute(attributes);
    }

    public void addClosedTextElement(String elementName, String text, String ... attributes) {
        this.addElement(elementName);
        this.addAttribute(attributes);
        this.addText(text, false);
        this.closeElement(false);
    }

    public void addElement(String elementName, Map<String, String> attributes) {
        this.addElement(elementName);
        this.addAttribute(attributes);
    }

    public void closeElement() {
        this.closeElement(true);
    }

    public void closeElement(boolean elementOnNewLine) {
        if (this.elementStack.isEmpty()) {
            throw new MalformedXMLRuntimeException("Illegal call to closeElement");
        }
        String element = this.elementStack.pop();
        if (this.incompleteOpenTag) {
            if (this.closeOnNewLine) {
                this.pw.print(SEPARATOR);
                this.pw.print(this.getIndent());
            }
            this.pw.print("/>");
            this.incompleteOpenTag = false;
        } else {
            if (elementOnNewLine) {
                this.pw.print(SEPARATOR);
                this.pw.print(this.getIndent());
            }
            this.pw.print("</");
            this.pw.print(element);
            this.pw.print(">");
        }
        this.hasAttributes = false;
    }

    public void addText(String in) {
        this.addText(in, true);
    }

    public void addText(String in, boolean onNewLine) {
        if (in.trim().length() == 0) {
            return;
        }
        this.finishIncompleteTag();
        if (onNewLine) {
            this.pw.print(SEPARATOR);
            this.pw.print(this.getIndent());
        }
        this.pw.print(StringEscapeUtils.escapeXml((String)in.trim()));
    }

    public void addCDATA(String in) {
        if (in.trim().length() == 0) {
            return;
        }
        this.finishIncompleteTag();
        StringBuilder sb = new StringBuilder();
        sb.append(SEPARATOR).append(this.getIndent()).append("<![CDATA[");
        String data = in.trim();
        for (String token : data.split(SEPARATOR)) {
            sb.append(SEPARATOR).append(this.getIndent()).append(this.getDefaultIndent()).append(token.trim());
        }
        sb.append(SEPARATOR).append(this.getIndent()).append("]]>");
        this.writeGeneric(sb.toString());
    }

    public void finish() {
        this.closeAll();
        this.pw.flush();
    }

    public String getIndent() {
        return this.getIndent(this.getStackSize());
    }

    public String getLineSep() {
        return SEPARATOR;
    }

    private void closeAll() {
        while (!this.elementStack.isEmpty()) {
            this.closeElement();
        }
    }

    private void finishIncompleteTag() {
        if (this.incompleteOpenTag) {
            this.pw.print(">");
            this.incompleteOpenTag = false;
        }
    }

    private void writeGeneric(String in) {
        this.pw.print(in);
    }

    private String getIndent(int numUnits) {
        StringBuilder indentString = new StringBuilder();
        int max = this.startIndent + numUnits * this.indent;
        indentString.append(" ".repeat(Math.max(0, max)));
        return indentString.toString();
    }

    private String getDefaultIndent() {
        return this.getIndent(1);
    }

    private int getStackSize() {
        return this.elementStack.size();
    }

    private String qualify(String name, String ns) {
        return ns + ":" + name;
    }

    private static class Stack
    extends ArrayList<String> {
        private static final long serialVersionUID = 1L;

        private Stack() {
        }

        public void push(String s) {
            super.add(0, s);
        }

        public String pop() {
            return (String)super.remove(0);
        }
    }

    private static class MalformedXMLRuntimeException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        private MalformedXMLRuntimeException(String message) {
            super(message);
        }
    }
}

