/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.commons.util;

import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import com.wavemaker.commons.WMRuntimeException;
import com.wavemaker.commons.io.File;
import com.wavemaker.commons.io.local.LocalFile;
import com.wavemaker.commons.util.PropertiesToMapConverter;
import com.wavemaker.commons.util.WMIOUtils;
import com.wavemaker.commons.util.WMYamlProcessor;
import java.io.OutputStream;
import java.util.Map;
import java.util.Properties;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public class YamlFileUtils {
    private static final YAMLMapper yamlMapper = new YAMLMapper().configure(YAMLGenerator.Feature.WRITE_DOC_START_MARKER, false);

    public static Properties loadPropertiesFromYamlFile(File file) {
        WMYamlProcessor wmYamlProcessor = new WMYamlProcessor();
        wmYamlProcessor.setResources(new Resource[]{new FileSystemResource(((LocalFile)file).getLocalFile().getAbsolutePath())});
        return wmYamlProcessor.getProperties();
    }

    public static void writePropertiesToYamlFile(Properties properties, File file) {
        OutputStream outputStream = null;
        try {
            outputStream = file.getContent().asOutputStream();
            Map<String, Object> map = PropertiesToMapConverter.propertiesToMapConverter(properties);
            yamlMapper.writeValue(outputStream, map);
        }
        catch (Exception e) {
            throw new WMRuntimeException(e);
        }
        finally {
            WMIOUtils.closeSilently(outputStream);
        }
    }
}

