/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.commons.web;

import com.wavemaker.commons.web.filter.Request;
import com.wavemaker.commons.web.filter.ServerTimingMetric;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpServletResponseWrapper;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

public class RequestTrackingResponseWrapper
extends HttpServletResponseWrapper {
    private static final Logger logger = LoggerFactory.getLogger(RequestTrackingResponseWrapper.class);
    private static final String SERVER_TIMING_HEADER = "Server-Timing";
    private Request request;
    private boolean serverTimingHeaderFlag;

    public RequestTrackingResponseWrapper(HttpServletResponse response, Request request) {
        super(response);
        this.request = request;
    }

    public ServletOutputStream getOutputStream() throws IOException {
        this.writeServerTimingResponseHeader();
        return super.getOutputStream();
    }

    public PrintWriter getWriter() throws IOException {
        this.writeServerTimingResponseHeader();
        return super.getWriter();
    }

    public void writeServerTimingResponseHeader() {
        if (!this.serverTimingHeaderFlag) {
            try {
                long endTime = System.currentTimeMillis();
                this.request.getServerTimingMetricList().add(0, new ServerTimingMetric("server", endTime - this.request.getStartTime(), null));
                this.setServerTimingResponseHeader();
            }
            catch (Exception e) {
                logger.warn("Failed to write Server-Timing header", (Throwable)e);
            }
            this.serverTimingHeaderFlag = true;
        }
    }

    private void setServerTimingResponseHeader() {
        List<ServerTimingMetric> serverTimingMetrics = this.request.getServerTimingMetricList();
        LinkedMultiValueMap multiValueMap = new LinkedMultiValueMap();
        serverTimingMetrics.forEach(arg_0 -> RequestTrackingResponseWrapper.lambda$setServerTimingResponseHeader$0((MultiValueMap)multiValueMap, arg_0));
        String headerValue = multiValueMap.keySet().stream().map(arg_0 -> RequestTrackingResponseWrapper.lambda$setServerTimingResponseHeader$1((MultiValueMap)multiValueMap, arg_0)).collect(Collectors.joining(", "));
        logger.debug("Setting header ServerTiming with value {}", (Object)headerValue);
        this.addHeader(SERVER_TIMING_HEADER, headerValue);
    }

    private static /* synthetic */ String lambda$setServerTimingResponseHeader$1(MultiValueMap multiValueMap, String subRequestScope) {
        Collection values = (Collection)multiValueMap.get((Object)subRequestScope);
        ServerTimingMetric toBeSavedServerTimingMetric = null;
        if (values.size() != 1) {
            long totalProcessingTime = 0L;
            for (ServerTimingMetric serverTimingMetric : values) {
                totalProcessingTime += serverTimingMetric.getProcessingTime().longValue();
            }
            toBeSavedServerTimingMetric = new ServerTimingMetric(subRequestScope, totalProcessingTime, values.size() + " times");
        } else {
            toBeSavedServerTimingMetric = (ServerTimingMetric)values.iterator().next();
        }
        return toBeSavedServerTimingMetric.asString();
    }

    private static /* synthetic */ void lambda$setServerTimingResponseHeader$0(MultiValueMap multiValueMap, ServerTimingMetric x) {
        multiValueMap.add((Object)x.getName(), (Object)x);
    }
}

