/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.commons.web.filter;

import com.wavemaker.commons.web.RequestTrackingResponseWrapper;
import com.wavemaker.commons.web.filter.Request;
import com.wavemaker.commons.web.filter.ServerTimingMetric;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.http.HttpHeaders;
import org.springframework.web.filter.DelegatingFilterProxy;

public class RequestTrackingFilter
extends DelegatingFilterProxy {
    private String requestTrackingIdPrefix;
    private String requestTrackingHeaderName;
    private boolean serverTimingsEnabled = true;
    public static final char REQUEST_ID_SEPARATOR = '-';
    private static final String SERVER_TIMING_HEADER = "Server-Timing";
    private static ThreadLocal<Request> requestTrackingMap = new ThreadLocal();
    private static final Logger LOGGER = LoggerFactory.getLogger(RequestTrackingFilter.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        HttpServletResponse httpServletResponse = (HttpServletResponse)response;
        String requestTrackingId = httpServletRequest.getHeader(this.requestTrackingHeaderName);
        if (StringUtils.isBlank((CharSequence)requestTrackingId)) {
            requestTrackingId = this.generateNewRequestId();
            LOGGER.debug("Request tracking id not set in header, setting new tracking id {}", (Object)requestTrackingId);
        } else if (!requestTrackingId.contains(".")) {
            requestTrackingId = this.generateNewRequestId(requestTrackingId);
            LOGGER.debug("Request Tagging id set in header from kong, so setting prefix {}", (Object)requestTrackingId);
        }
        try {
            MDC.put((String)this.requestTrackingHeaderName, (String)requestTrackingId);
            Request currentTrackingRequest = new Request(requestTrackingId);
            requestTrackingMap.set(currentTrackingRequest);
            httpServletResponse.setHeader(this.requestTrackingHeaderName, requestTrackingId);
            RequestTrackingResponseWrapper requestTrackingResponseWrapper = new RequestTrackingResponseWrapper((HttpServletResponse)response, requestTrackingMap.get());
            chain.doFilter(request, (ServletResponse)requestTrackingResponseWrapper);
            requestTrackingResponseWrapper.writeServerTimingResponseHeader();
        }
        finally {
            requestTrackingMap.remove();
            MDC.remove((String)this.requestTrackingHeaderName);
        }
    }

    public void destroy() {
    }

    public String generateNewSubRequestId(String context) {
        String subRequestId;
        Request currentRequest = requestTrackingMap.get();
        if (currentRequest == null) {
            subRequestId = this.generateNewRequestId();
            LOGGER.info("creating a new sub request id with value {} for context {}", (Object)subRequestId, (Object)context);
        } else if (currentRequest.getId().length() > 56) {
            subRequestId = this.generateNewRequestId();
            LOGGER.warn("Current Request tracking id {} is too long, creating a new sub request id with value {} for context {} ", new Object[]{currentRequest.getId(), subRequestId, context});
        } else {
            StringBuilder sb = new StringBuilder(currentRequest.getId()).append('-');
            sb.append(String.format("%02d", currentRequest.getAndIncrementSubRequestCounter()));
            if (StringUtils.isNotBlank((CharSequence)context)) {
                sb.append(context);
            }
            subRequestId = sb.toString();
            LOGGER.debug("Creating new sub request tracking id {} for request context {}", (Object)subRequestId, (Object)context);
        }
        return subRequestId;
    }

    private String generateNewRequestId() {
        return this.requestTrackingIdPrefix + "." + RandomStringUtils.randomAlphanumeric((int)8);
    }

    private String generateNewRequestId(String requestTrackingId) {
        return this.requestTrackingIdPrefix + "." + requestTrackingId;
    }

    public Runnable getRunnableInSubRequestScope(Runnable runnable) {
        String subRequestId = this.generateNewSubRequestId("");
        return () -> {
            try {
                MDC.put((String)this.requestTrackingHeaderName, (String)subRequestId);
                requestTrackingMap.set(new Request(subRequestId));
                runnable.run();
            }
            finally {
                requestTrackingMap.remove();
                MDC.remove((String)this.requestTrackingHeaderName);
            }
        };
    }

    public String getRequestTrackingIdPrefix() {
        return this.requestTrackingIdPrefix;
    }

    public void setRequestTrackingIdPrefix(String requestTrackingIdPrefix) {
        this.requestTrackingIdPrefix = requestTrackingIdPrefix;
    }

    public String getRequestTrackingHeaderName() {
        return this.requestTrackingHeaderName;
    }

    public void setRequestTrackingHeaderName(String requestTrackingHeaderName) {
        this.requestTrackingHeaderName = requestTrackingHeaderName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T executeNewSubRequest(String context, Function<String, T> function) {
        Request request;
        String subRequestScopeId = this.generateNewSubRequestId(context);
        if (this.serverTimingsEnabled && (request = requestTrackingMap.get()) != null) {
            long startTime = System.currentTimeMillis();
            String previousSubRequestScope = request.getSubRequestScope();
            String subRequestScope = subRequestScopeId.substring(request.getId().length() + 1);
            try {
                T returnValue;
                request.setSubRequestScope(subRequestScope);
                T t = returnValue = function.apply(subRequestScopeId);
                return t;
            }
            finally {
                request.setSubRequestScope(previousSubRequestScope);
                long processingTime = System.currentTimeMillis() - startTime;
                this.addServerTimingMetrics(new ServerTimingMetric(subRequestScope + "client", processingTime, null));
            }
        }
        return function.apply(subRequestScopeId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T executeInSubRequestScope(String subRequestScope, Supplier<T> supplier) {
        Request request;
        if (this.serverTimingsEnabled && (request = requestTrackingMap.get()) != null) {
            long startTime = System.currentTimeMillis();
            String previousSubRequestScope = request.getSubRequestScope();
            try {
                T returnValue;
                request.setSubRequestScope(subRequestScope);
                T t = returnValue = supplier.get();
                return t;
            }
            finally {
                request.setSubRequestScope(previousSubRequestScope);
                long processingTime = System.currentTimeMillis() - startTime;
                this.addServerTimingMetrics(new ServerTimingMetric(subRequestScope + "client", processingTime, null));
            }
        }
        return supplier.get();
    }

    public void addServerTimingMetricsForSubRequest(HttpHeaders httpHeaders) {
        if (this.serverTimingsEnabled) {
            try {
                List serverTimings;
                Request request = requestTrackingMap.get();
                if (request != null && StringUtils.isNotBlank((CharSequence)request.getSubRequestScope()) && CollectionUtils.isNotEmpty((Collection)(serverTimings = httpHeaders.get((Object)SERVER_TIMING_HEADER)))) {
                    for (String serverTiming : serverTimings) {
                        String[] serverTimingEntries;
                        for (String s : serverTimingEntries = serverTiming.split(", ")) {
                            ServerTimingMetric serverTimingMetric = ServerTimingMetric.parse(s);
                            serverTimingMetric.setName(request.getSubRequestScope() + "-" + serverTimingMetric.getName());
                            this.addServerTimingMetrics(serverTimingMetric);
                        }
                    }
                }
            }
            catch (Exception e) {
                this.logger.warn((Object)"Failed to add server timings for sub request", (Throwable)e);
            }
        }
    }

    public void addServerTimingMetrics(ServerTimingMetric serverTimingMetric) {
        Request request;
        if (this.serverTimingsEnabled && (request = requestTrackingMap.get()) != null) {
            request.addServerTimingMetric(serverTimingMetric);
        }
    }

    public void setServerTimingsEnabled(boolean serverTimingsEnabled) {
        this.serverTimingsEnabled = serverTimingsEnabled;
    }
}

