/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.commons.web.filter;

import java.util.Objects;

public class ServerTimingMetric {
    private String name;
    private Long processingTime;
    private String description;

    public ServerTimingMetric(String name, Long processingTime, String description) {
        this.name = name;
        this.processingTime = processingTime;
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public Long getProcessingTime() {
        return this.processingTime;
    }

    public String getDescription() {
        return this.description;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setProcessingTime(Long processingTime) {
        this.processingTime = processingTime;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public static ServerTimingMetric parse(String val) {
        if (val == null) {
            throw new IllegalArgumentException(val);
        }
        String s = val.trim();
        String[] strings = s.split(";");
        String name = null;
        Long processingTime = null;
        String description = null;
        for (String str : strings) {
            String[] split = (str = str.trim()).split("=");
            if (split.length == 1) {
                if (name != null) {
                    throw new IllegalArgumentException(val);
                }
                name = split[0].trim();
                continue;
            }
            if (split.length == 2) {
                String key = split[0].trim();
                String value = split[1].trim();
                if ("dur".equals(key)) {
                    processingTime = Long.parseLong(value);
                    continue;
                }
                if (!"desc".equals(key)) continue;
                if (value.startsWith("\"") && value.endsWith("\"")) {
                    if (value.length() >= 2) {
                        value = value.substring(1, value.length() - 1);
                    } else {
                        throw new IllegalArgumentException(val);
                    }
                }
                description = value;
                continue;
            }
            throw new IllegalArgumentException(val);
        }
        return new ServerTimingMetric(name, processingTime, description);
    }

    public String toString() {
        return this.asString();
    }

    public String asString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.name);
        if (this.description != null) {
            sb.append("(").append(this.description).append(")");
        }
        if (this.processingTime != null) {
            sb.append(";dur=").append(this.processingTime);
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServerTimingMetric that = (ServerTimingMetric)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.processingTime, that.processingTime) && Objects.equals(this.description, that.description);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.processingTime, this.description);
    }
}

