/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.commons.zip;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.springframework.util.Assert;

public class DynamicZipInputStream
extends InputStream {
    private static final int BUFFER_SIZE = 4096;
    private static final InputStream EMPTY_STREAM = new InputStream(){

        @Override
        public int read() throws IOException {
            return -1;
        }
    };
    private ZipOutputStream zipStream;
    private Iterator<Entry> entries;
    private InputStream entryStream = EMPTY_STREAM;
    private byte[] buffer = new byte[4096];
    private long fileCount;
    private BufferedOutputStream outputStream = new BufferedOutputStream();
    private byte[] singleByte = new byte[1];

    public DynamicZipInputStream(Iterable<Entry> entries) {
        Assert.notNull(entries, (String)"Entries must not be null");
        this.zipStream = new ZipOutputStream(this.outputStream);
        this.entries = entries.iterator();
    }

    @Override
    public int read() throws IOException {
        int s = this.read(this.singleByte);
        if (s == 1) {
            return this.singleByte[0] & 0xFF;
        }
        return -1;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        return this.doRead(b, off, len, true);
    }

    private int doRead(byte[] b, int off, int len, boolean lastWriteWasSuccessful) throws IOException {
        if (this.outputStream.getAvailable() > 0) {
            return this.outputStream.read(b, off, len);
        }
        if (!lastWriteWasSuccessful) {
            return -1;
        }
        this.outputStream.clear();
        boolean writeSuccess = this.writeMoreData();
        return this.doRead(b, off, len, writeSuccess);
    }

    protected boolean writeMoreData() throws IOException {
        int count = this.entryStream.read(this.buffer);
        if (count != -1) {
            this.zipStream.write(this.buffer, 0, count);
            return true;
        }
        if (this.entryStream != EMPTY_STREAM) {
            this.zipStream.closeEntry();
            this.entryStream.close();
            this.entryStream = EMPTY_STREAM;
        }
        if (this.entries.hasNext()) {
            ++this.fileCount;
            Entry entry = this.entries.next();
            this.zipStream.putNextEntry(new ZipEntry(entry.getName()));
            this.entryStream = entry.getInputStream();
            if (this.entryStream == null) {
                this.entryStream = EMPTY_STREAM;
            }
            return true;
        }
        if (this.fileCount == 0L) {
            ++this.fileCount;
            this.zipStream.putNextEntry(new ZipEntry("__empty__"));
            this.entryStream = EMPTY_STREAM;
            return true;
        }
        this.zipStream.flush();
        this.zipStream.close();
        return false;
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.zipStream.close();
    }

    private static class BufferedOutputStream
    extends ByteArrayOutputStream {
        private int offset;

        private BufferedOutputStream() {
        }

        public int getAvailable() {
            return this.count - this.offset;
        }

        public void clear() {
            this.count = 0;
            this.offset = 0;
        }

        public int read(byte[] b, int off, int len) {
            int length = Math.min(this.getAvailable(), len);
            Assert.state((length > 0 ? 1 : 0) != 0, (String)"No data available in buffer");
            System.arraycopy(this.buf, this.offset, b, off, length);
            this.offset += length;
            return length;
        }
    }

    public static interface Entry {
        public String getName();

        public InputStream getInputStream() throws IOException;
    }
}

