/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.commons.zip;

import com.wavemaker.commons.MessageResource;
import com.wavemaker.commons.io.File;
import com.wavemaker.commons.io.Folder;
import com.wavemaker.commons.io.JailedResourcePath;
import com.wavemaker.commons.io.NoCloseInputStream;
import com.wavemaker.commons.io.Resource;
import com.wavemaker.commons.io.ResourcePath;
import com.wavemaker.commons.io.exception.ReadOnlyResourceException;
import com.wavemaker.commons.io.exception.ResourceException;
import com.wavemaker.commons.io.store.FileStore;
import com.wavemaker.commons.io.store.FolderStore;
import com.wavemaker.commons.io.store.ResourceStore;
import com.wavemaker.commons.io.store.StoredFile;
import com.wavemaker.commons.io.store.StoredFolder;
import com.wavemaker.commons.util.WMIOUtils;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.IOUtils;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

abstract class ZipResourceStore
implements ResourceStore {
    private final JailedResourcePath path;
    private final ZipFile zipFile;

    public ZipResourceStore(ZipFile zipFile, JailedResourcePath path) {
        this.zipFile = zipFile;
        this.path = path;
    }

    protected ZipFile getZipFile() {
        return this.zipFile;
    }

    @Override
    public JailedResourcePath getPath() {
        return this.path;
    }

    @Override
    public Resource getExisting(JailedResourcePath path) {
        ZipFile.ZipFileDetailsEntry entry = this.getZipFile().getEntry(path, false);
        if (entry == null) {
            return null;
        }
        return entry.isFolder() ? this.getFolder(path) : this.getFile(path);
    }

    @Override
    public Folder getFolder(JailedResourcePath path) {
        final ZipFolderStore store = new ZipFolderStore(this.getZipFile(), path);
        return new StoredFolder(){

            @Override
            protected FolderStore getStore() {
                return store;
            }
        };
    }

    @Override
    public File getFile(JailedResourcePath path) {
        final ZipFileStore store = new ZipFileStore(this.getZipFile(), path);
        return new StoredFile(){

            @Override
            protected FileStore getStore() {
                return store;
            }
        };
    }

    @Override
    public boolean exists() {
        return this.getZipFile().getEntry(this.path, false) != null;
    }

    @Override
    public Resource rename(String name) {
        throw this.createReadOnlyException();
    }

    @Override
    public void delete() {
        throw this.createReadOnlyException();
    }

    @Override
    public void create() {
        throw this.createReadOnlyException();
    }

    @Override
    public int hashCode() {
        return this.zipFile.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ZipResourceStore other = (ZipResourceStore)obj;
        return ObjectUtils.nullSafeEquals((Object)this.zipFile, (Object)other.zipFile);
    }

    protected final ReadOnlyResourceException createReadOnlyException() {
        throw new ReadOnlyResourceException(MessageResource.create("com.wavemaker.commons.readOnly.zip.file"), this.getZipFile());
    }

    private static class ZipFile {
        private final File file;
        private final Map<ResourcePath, ZipFileDetailsEntry> entries = new HashMap<ResourcePath, ZipFileDetailsEntry>();
        private boolean loadedAtLeastOnce;
        private long size;
        private long lastModified;

        public ZipFile(File file) {
            Assert.notNull((Object)file, (String)"ZipFile must not be null");
            Assert.isTrue((boolean)file.exists(), (String)"ZipFile must exist");
            this.file = file;
        }

        public long getLastModified() {
            return this.file.getLastModified();
        }

        private ZipFileDetailsEntry getEntry(JailedResourcePath path) {
            return this.getEntry(path, true);
        }

        private ZipFileDetailsEntry getEntry(JailedResourcePath path, boolean required) {
            ResourcePath unjailedPath;
            ZipFileDetailsEntry entry;
            if (this.isUnderlyingZipFileChanged()) {
                try {
                    this.reloadZipFile();
                }
                catch (IOException e) {
                    throw new ResourceException(e);
                }
            }
            if ((entry = this.entries.get(unjailedPath = path.getUnjailedPath())) == null && required) {
                return new MissingZipFileDetailsEntry(unjailedPath);
            }
            return entry;
        }

        private boolean isUnderlyingZipFileChanged() {
            return !this.loadedAtLeastOnce || this.size != this.file.getSize() || this.lastModified != this.file.getLastModified();
        }

        private void reloadZipFile() throws IOException {
            this.addZipEntries();
            this.createMissingFolderEntries();
            this.size = this.file.getSize();
            this.lastModified = this.file.getLastModified();
            this.loadedAtLeastOnce = true;
        }

        protected final ZipInputStream openZipInputStream() {
            return new ZipInputStream(new BufferedInputStream(this.file.getContent().asInputStream()));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addZipEntries() throws IOException {
            try (ZipInputStream zipInputStream = this.openZipInputStream();){
                ZipEntry entry = zipInputStream.getNextEntry();
                while (entry != null) {
                    ResourcePath path = new ResourcePath().get(entry.getName());
                    this.entries.put(path, new ZipEntryZipFileDetailsEntry(path, entry));
                    entry = zipInputStream.getNextEntry();
                }
            }
        }

        private void createMissingFolderEntries() {
            ArrayList<MissingZipFileDetailsEntry> missingEntries = new ArrayList<MissingZipFileDetailsEntry>();
            Set<ResourcePath> paths = this.entries.keySet();
            for (ResourcePath path : paths) {
                for (path = path.getParent(); path != null; path = path.getParent()) {
                    if (this.entries.containsKey(path)) continue;
                    missingEntries.add(new MissingZipFileDetailsEntry(path));
                }
            }
            for (MissingZipFileDetailsEntry missingEntry : missingEntries) {
                this.entries.put(missingEntry.getPath(), missingEntry);
            }
        }

        public int hashCode() {
            return this.file.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ZipFile other = (ZipFile)obj;
            return ObjectUtils.nullSafeEquals((Object)this.file, (Object)other.file);
        }

        private abstract class ZipFileDetailsEntry {
            private List<String> list;
            private final ResourcePath path;

            public ZipFileDetailsEntry(ResourcePath path) {
                this.path = path;
            }

            public abstract boolean isFolder();

            public abstract InputStream getInputStream() throws IOException;

            public abstract long getSize();

            public Iterable<String> list() {
                if (this.list == null) {
                    this.list = new ArrayList<String>();
                    if (this.isFolder()) {
                        for (ResourcePath entryPath : ZipFile.this.entries.keySet()) {
                            if (!this.isParent(entryPath)) continue;
                            this.list.add(entryPath.getName());
                        }
                    }
                }
                return this.list;
            }

            private boolean isParent(ResourcePath path) {
                return path != null && this.path.equals(path.getParent());
            }

            public ResourcePath getPath() {
                return this.path;
            }
        }

        private class MissingZipFileDetailsEntry
        extends ZipFileDetailsEntry {
            public MissingZipFileDetailsEntry(ResourcePath path) {
                super(path);
            }

            @Override
            public boolean isFolder() {
                return true;
            }

            @Override
            public InputStream getInputStream() {
                return null;
            }

            @Override
            public long getSize() {
                return 0L;
            }
        }

        private class ZipEntryZipFileDetailsEntry
        extends ZipFileDetailsEntry {
            private final ZipEntry entry;
            private WeakReference<byte[]> contents;

            public ZipEntryZipFileDetailsEntry(ResourcePath path, ZipEntry entry) {
                super(path);
                this.entry = entry;
            }

            @Override
            public boolean isFolder() {
                return this.entry.isDirectory();
            }

            @Override
            public InputStream getInputStream() throws IOException {
                byte[] bytes = this.contents == null ? null : (byte[])this.contents.get();
                try {
                    if (bytes == null) {
                        bytes = this.getZipEntryBytes();
                        this.contents = new WeakReference<byte[]>(bytes);
                    }
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes);
                    return byteArrayInputStream;
                }
                finally {
                    this.contents = null;
                }
            }

            private byte[] getZipEntryBytes() throws IOException {
                ZipInputStream zipInputStream = ZipFile.this.openZipInputStream();
                try {
                    ZipEntry zipEntry = zipInputStream.getNextEntry();
                    while (zipEntry != null) {
                        if (!zipEntry.isDirectory()) {
                            ResourcePath path = new ResourcePath().get(zipEntry.getName());
                            if (this.getPath().equals(path)) {
                                byte[] byArray = IOUtils.toByteArray((InputStream)new NoCloseInputStream(zipInputStream));
                                return byArray;
                            }
                        }
                        zipEntry = zipInputStream.getNextEntry();
                    }
                    throw new IllegalStateException("Unable to find ZipEntry for " + String.valueOf(this.getPath()));
                }
                finally {
                    WMIOUtils.closeSilently(zipInputStream);
                }
            }

            @Override
            public long getSize() {
                return this.entry.getSize();
            }
        }
    }

    static class ZipFolderStore
    extends ZipResourceStore
    implements FolderStore {
        public ZipFolderStore(File zipFile) {
            this(new ZipFile(zipFile), new JailedResourcePath());
        }

        public ZipFolderStore(ZipFile zipFile, JailedResourcePath path) {
            super(zipFile, path);
        }

        @Override
        public Iterable<String> list() {
            return this.getZipFile().getEntry(this.getPath()).list();
        }
    }

    static class ZipFileStore
    extends ZipResourceStore
    implements FileStore {
        public ZipFileStore(ZipFile zipFile, JailedResourcePath path) {
            super(zipFile, path);
        }

        @Override
        public InputStream getInputStream() {
            try {
                return this.getZipFile().getEntry(this.getPath()).getInputStream();
            }
            catch (IOException e) {
                throw new ResourceException(e);
            }
        }

        @Override
        public OutputStream getOutputStream() {
            throw this.createReadOnlyException();
        }

        @Override
        public OutputStream getOutputStream(boolean append) {
            throw this.createReadOnlyException();
        }

        @Override
        public long getSize() {
            return this.getZipFile().getEntry(this.getPath()).getSize();
        }

        @Override
        public long getLastModified() {
            return this.getZipFile().getLastModified();
        }

        @Override
        public void touch() {
            throw this.createReadOnlyException();
        }
    }
}

