/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.commons;

import com.wavemaker.commons.MessageResource;
import com.wavemaker.commons.MessageResourceHolder;
import com.wavemaker.commons.WMCommonException;

public abstract class WMException
extends Exception
implements WMCommonException {
    private static final long serialVersionUID = 1L;
    private MessageResourceHolder messageResourceHolder = new MessageResourceHolder();

    public WMException(Throwable cause) {
        super(cause);
    }

    public WMException(MessageResource resource, Throwable cause) {
        this(cause);
        this.messageResourceHolder.setMessageResource(resource);
    }

    public WMException(MessageResource resource, Object ... args) {
        this.messageResourceHolder.setMessageResource(resource);
        this.messageResourceHolder.setArgs(args);
    }

    public WMException(MessageResource resource, Throwable cause, Object ... args) {
        this(cause);
        this.messageResourceHolder.setMessageResource(resource);
        this.messageResourceHolder.setArgs(args);
    }

    public WMException(String msg) {
        super(msg);
    }

    @Override
    public MessageResourceHolder getMessageResourceHolder() {
        return this.messageResourceHolder;
    }

    @Override
    public String getMessage() {
        MessageResource messageResource = this.messageResourceHolder.getMessageResource();
        String message = messageResource != null ? messageResource.getMessage(this.messageResourceHolder.getArgs()) : this.messageResourceHolder.getMessage();
        return message == null ? "" : message;
    }
}

