/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.commons.auth.oauth2.extractors;

import com.fasterxml.jackson.databind.JsonNode;
import com.wavemaker.commons.auth.oauth2.extractors.AccessTokenRequestContext;
import com.wavemaker.commons.auth.oauth2.extractors.MediaTypeBasedAccessTokenExtractor;
import com.wavemaker.commons.json.JSONUtils;
import org.springframework.http.MediaType;

public class JsonFormatAccessTokenExtractor
extends MediaTypeBasedAccessTokenExtractor {
    @Override
    public boolean canRead(MediaType mediaType) {
        return MediaType.APPLICATION_JSON.equals((Object)mediaType) || MediaType.APPLICATION_JSON_UTF8.equals((Object)mediaType);
    }

    @Override
    protected String obtainAccessToken(AccessTokenRequestContext accessTokenRequestContext) {
        JsonNode jsonNode = JSONUtils.readTree(accessTokenRequestContext.getResponseBody());
        if (jsonNode.has("access_token")) {
            JsonNode textNode = jsonNode.get("access_token");
            return textNode.asText();
        }
        return null;
    }
}

