/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.commons.classloader;

import com.wavemaker.commons.classloader.WMCallable;
import com.wavemaker.commons.io.Resource;
import com.wavemaker.commons.io.ResourceURL;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceClassLoaderUtils {
    private static final Logger logger = LoggerFactory.getLogger(ResourceClassLoaderUtils.class);

    private ResourceClassLoaderUtils() {
    }

    public static ClassLoader getClassLoaderForResources(ClassLoader parent, Resource ... resources) {
        return ResourceClassLoaderUtils.getClassLoaderForResources(false, parent, resources);
    }

    public static ClassLoader getClassLoaderForResources(boolean nonLocking, ClassLoader parent, Resource ... resources) {
        try {
            URL[] urls = ResourceURL.getForResources(Arrays.asList(resources), nonLocking).toArray(new URL[resources.length]);
            return AccessController.doPrivileged(() -> new URLClassLoader(urls, parent));
        }
        catch (MalformedURLException ex) {
            throw new AssertionError((Object)ex);
        }
    }

    public static void runInClassLoaderContext(Runnable runnable, ClassLoader cl) {
        ResourceClassLoaderUtils.runInClassLoaderContext(ResourceClassLoaderUtils.asCallable(runnable), null, cl);
    }

    public static <V> V runInClassLoaderContext(WMCallable<V> executable, ClassLoader cl) {
        return ResourceClassLoaderUtils.runInClassLoaderContext(executable, null, cl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <V> V runInClassLoaderContext(WMCallable<V> executable, Runnable finalizerTask, ClassLoader cl) {
        ClassLoader c = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(cl);
            V v = executable.call();
            return v;
        }
        finally {
            try {
                if (finalizerTask != null) {
                    finalizerTask.run();
                }
            }
            catch (Exception e) {
                logger.warn("Failed to execute finalizer task", (Throwable)e);
            }
            finally {
                Thread.currentThread().setContextClassLoader(c);
            }
        }
    }

    private static WMCallable<Object> asCallable(Runnable runnable) {
        return () -> {
            runnable.run();
            return null;
        };
    }
}

