/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.commons.comparator;

import java.util.regex.Pattern;

class PatternInfo {
    private static final Pattern VARIABLE_PATTERN = Pattern.compile("\\{[^/]+?\\}");
    private final String pattern;
    private int uriVars;
    private int singleWildcards;
    private int doubleWildcards;
    private boolean catchAllPattern;
    private boolean prefixPattern;
    private Integer length;

    public PatternInfo(String pattern) {
        this.pattern = pattern;
        if (this.pattern != null) {
            this.initCounters();
            this.catchAllPattern = this.pattern.equals("/**") || this.pattern.equals("/");
            boolean bl = this.prefixPattern = !this.catchAllPattern && this.pattern.endsWith("/**");
        }
        if (this.uriVars == 0) {
            this.length = this.pattern != null ? this.pattern.length() : 0;
        }
    }

    protected void initCounters() {
        int pos = 0;
        while (pos < this.pattern.length()) {
            if (this.pattern.charAt(pos) == '{') {
                ++this.uriVars;
                ++pos;
                continue;
            }
            if (this.pattern.charAt(pos) == '*') {
                if (pos + 1 < this.pattern.length() && this.pattern.charAt(pos + 1) == '*') {
                    ++this.doubleWildcards;
                    pos += 2;
                    continue;
                }
                if (pos > 0 && !this.pattern.substring(pos - 1).equals(".*")) {
                    ++this.singleWildcards;
                    ++pos;
                    continue;
                }
                ++pos;
                continue;
            }
            ++pos;
        }
    }

    public int getUriVars() {
        return this.uriVars;
    }

    public int getSingleWildcards() {
        return this.singleWildcards;
    }

    public int getDoubleWildcards() {
        return this.doubleWildcards;
    }

    public boolean isLeastSpecific() {
        return this.pattern == null || this.catchAllPattern;
    }

    public boolean isPrefixPattern() {
        return this.prefixPattern;
    }

    public int getTotalCount() {
        return this.uriVars + this.singleWildcards + 2 * this.doubleWildcards;
    }

    public int getLength() {
        if (this.length == null) {
            this.length = VARIABLE_PATTERN.matcher(this.pattern).replaceAll("#").length();
        }
        return this.length;
    }
}

