/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.commons.comparator;

import java.util.Comparator;
import java.util.StringTokenizer;
import org.apache.commons.lang3.StringUtils;

public abstract class UrlStringComparator<T>
implements Comparator<T> {
    @Override
    public int compare(T s1, T s2) {
        String urlPattern1 = this.getUrlPattern(s1);
        String urlPattern2 = this.getUrlPattern(s2);
        if (StringUtils.isBlank((CharSequence)urlPattern1) && StringUtils.isBlank((CharSequence)urlPattern2)) {
            return 0;
        }
        if (StringUtils.isBlank((CharSequence)urlPattern1)) {
            return 1;
        }
        if (StringUtils.isBlank((CharSequence)urlPattern2)) {
            return -1;
        }
        StringTokenizer s1Tokens = new StringTokenizer(urlPattern1, "/");
        StringTokenizer s2Tokens = new StringTokenizer(urlPattern2, "/");
        if (s1Tokens.countTokens() > s2Tokens.countTokens()) {
            return this.compareTokens(s1Tokens, s2Tokens, s2Tokens.countTokens() - 1);
        }
        return this.compareTokens(s1Tokens, s2Tokens, s1Tokens.countTokens() - 1);
    }

    int compareTokens(StringTokenizer s1Tokens, StringTokenizer s2Tokens, int count) {
        for (int i = 0; i <= count; ++i) {
            String s1 = s1Tokens.nextToken();
            if (s1.equals("**")) {
                return 0;
            }
            String s2 = s2Tokens.nextToken();
            if (s2.equals("**")) {
                return 0;
            }
            int strCompare = s1.compareTo(s2);
            if (strCompare == 0) continue;
            return strCompare;
        }
        return 0;
    }

    public abstract String getUrlPattern(T var1);
}

