/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.commons.i18n;

import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class MultipleReloadableResourceBundleMessageSource
extends ReloadableResourceBundleMessageSource {
    private static final String PROPERTIES_SUFFIX = ".properties";
    private static final String XML_SUFFIX = ".xml";
    private PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();

    protected ReloadableResourceBundleMessageSource.PropertiesHolder refreshProperties(String filename, ReloadableResourceBundleMessageSource.PropertiesHolder propHolder) {
        if (filename.startsWith("classpath*:")) {
            return this.refreshClassPathProperties(filename, propHolder);
        }
        return super.refreshProperties(filename, propHolder);
    }

    private ReloadableResourceBundleMessageSource.PropertiesHolder refreshClassPathProperties(String filename, ReloadableResourceBundleMessageSource.PropertiesHolder propHolder) {
        long lastModified;
        Properties properties;
        block4: {
            properties = new Properties();
            lastModified = -1L;
            try {
                Resource[] resources = null;
                Resource[] propertiesResources = this.resolver.getResources(filename + PROPERTIES_SUFFIX);
                Resource[] xmlResources = this.resolver.getResources(filename + XML_SUFFIX);
                resources = this.getMergedResources(propertiesResources, xmlResources);
                if (resources.length > 0) {
                    String sourcePath = null;
                    ReloadableResourceBundleMessageSource.PropertiesHolder holder = null;
                    for (Resource resource : resources) {
                        sourcePath = resource.getURI().toString().replace(PROPERTIES_SUFFIX, "");
                        holder = super.refreshProperties(sourcePath, propHolder);
                        properties.putAll((Map<?, ?>)holder.getProperties());
                        if (lastModified >= resource.lastModified()) continue;
                        lastModified = resource.lastModified();
                    }
                }
            }
            catch (IOException ex) {
                if (!this.logger.isDebugEnabled()) break block4;
                this.logger.debug((Object)(filename + " could not be resolved in the file system"), (Throwable)ex);
            }
        }
        return new ReloadableResourceBundleMessageSource.PropertiesHolder((ReloadableResourceBundleMessageSource)this, properties, lastModified);
    }

    private Resource[] getMergedResources(Resource[] resources1, Resource[] resources2) {
        if (resources1 == null && resources2 == null) {
            return new Resource[0];
        }
        if (resources1 == null) {
            return resources2;
        }
        if (resources2 == null) {
            return resources1;
        }
        Resource[] resources = new Resource[resources1.length + resources2.length];
        int index = 0;
        int i = 0;
        while (i < resources1.length) {
            resources[index] = resources1[i];
            ++i;
            ++index;
        }
        i = 0;
        while (i < resources2.length) {
            resources[index] = resources2[i];
            ++i;
            ++index;
        }
        return resources;
    }
}

