/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.commons.io;

import com.wavemaker.commons.MessageResource;
import com.wavemaker.commons.io.AbstractFileContent;
import com.wavemaker.commons.io.File;
import com.wavemaker.commons.io.FileContent;
import com.wavemaker.commons.io.Folder;
import com.wavemaker.commons.io.Resource;
import com.wavemaker.commons.io.ResourceOperation;
import com.wavemaker.commons.io.ResourceStringFormat;
import com.wavemaker.commons.io.exception.ReadOnlyResourceException;
import com.wavemaker.commons.io.exception.ResourceDoesNotExistException;
import com.wavemaker.commons.util.WMIOUtils;
import java.io.InputStream;
import java.io.OutputStream;
import org.springframework.core.GenericTypeResolver;
import org.springframework.util.Assert;

public abstract class AbstractReadOnlyFile
implements File {
    private final FileContent content = new AbstractFileContent(){

        @Override
        public OutputStream asOutputStream() {
            throw AbstractReadOnlyFile.this.newReadOnlyResourceException();
        }

        @Override
        public OutputStream asOutputStream(boolean append) {
            throw AbstractReadOnlyFile.this.newReadOnlyResourceException();
        }

        @Override
        public InputStream asInputStream() {
            InputStream inputStream = AbstractReadOnlyFile.this.getInputStream();
            if (inputStream == null) {
                throw new ResourceDoesNotExistException(AbstractReadOnlyFile.this);
            }
            return inputStream;
        }
    };

    @Override
    public Folder getParent() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void delete() {
        throw this.newReadOnlyResourceException();
    }

    @Override
    public boolean exists() {
        InputStream inputStream = this.getInputStream();
        try {
            boolean bl = inputStream != null;
            return bl;
        }
        finally {
            WMIOUtils.closeSilently(inputStream);
        }
    }

    @Override
    public void createIfMissing() {
        throw this.newReadOnlyResourceException();
    }

    @Override
    public String toString() {
        return this.toString(ResourceStringFormat.FULL);
    }

    @Override
    public File moveTo(Folder folder) {
        throw this.newReadOnlyResourceException();
    }

    @Override
    public File copyTo(Folder folder) {
        File file = folder.getFile(this.getName());
        file.getContent().write(this);
        return file;
    }

    @Override
    public File rename(String name) {
        throw this.newReadOnlyResourceException();
    }

    @Override
    public void touch() {
        throw this.newReadOnlyResourceException();
    }

    @Override
    public long getSize() {
        return 0L;
    }

    @Override
    public long getLastModified() {
        return 0L;
    }

    @Override
    public FileContent getContent() {
        return this.content;
    }

    @Override
    public <R extends Resource, O extends ResourceOperation<R>> O performOperation(O operation) {
        Class typeArgument = GenericTypeResolver.resolveTypeArgument(operation.getClass(), ResourceOperation.class);
        Assert.isInstanceOf((Class)typeArgument, (Object)this);
        operation.perform((AbstractReadOnlyFile)this);
        return operation;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.toString().equals(obj.toString());
    }

    protected abstract InputStream getInputStream();

    protected ReadOnlyResourceException newReadOnlyResourceException() {
        return new ReadOnlyResourceException(MessageResource.create("com.wavemaker.commons.read.only.resource"), this.toString());
    }
}

