/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.commons.io;

import com.wavemaker.commons.io.AbstractReadOnlyFile;
import com.wavemaker.commons.io.File;
import com.wavemaker.commons.io.Folder;
import com.wavemaker.commons.io.Resource;
import com.wavemaker.commons.io.ResourcePath;
import com.wavemaker.commons.io.ResourceStringFormat;
import com.wavemaker.commons.util.FileValidationUtils;
import java.io.InputStream;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class ClassPathFile
extends AbstractReadOnlyFile {
    private final ClassLoader classLoader;
    private final ResourcePath path;

    public ClassPathFile(String path) {
        this((ClassLoader)null, path);
    }

    public ClassPathFile(ClassLoader classLoader, String path) {
        this.path = new ResourcePath().get(path);
        this.classLoader = classLoader == null ? ClassUtils.getDefaultClassLoader() : classLoader;
    }

    public ClassPathFile(Class<?> sourceClass, String path) {
        Assert.notNull(sourceClass, (String)"SourceClass must not be null");
        Assert.hasLength((String)path, (String)"Name must not be empty");
        this.classLoader = sourceClass.getClassLoader();
        this.path = new ResourcePath().get(sourceClass.getPackage().getName().replace(".", "/")).get(path);
    }

    @Override
    public String getName() {
        return this.path.getName();
    }

    @Override
    public String toString(ResourceStringFormat format) {
        return this.path.toString();
    }

    @Override
    public String toStringRelativeTo(Folder source) {
        Assert.notNull((Object)source, (String)"Source must not be null");
        return this.path.toStringRelativeTo(source.toString());
    }

    @Override
    public boolean isRelativeTo(Folder folder) {
        String relativePath = this.toStringRelativeTo(folder);
        return StringUtils.isNotBlank((CharSequence)relativePath);
    }

    @Override
    public boolean isModifiedAfter(long n) {
        return this.getLastModified() >= n;
    }

    @Override
    public boolean isModifiedAfter(Resource resource) {
        return this.getLastModified() >= resource.getLastModified();
    }

    @Override
    public boolean isModifiedBefore(long n) {
        return this.getLastModified() <= n;
    }

    @Override
    public boolean isModifiedBefore(Resource resource) {
        return this.getLastModified() <= resource.getLastModified();
    }

    @Override
    public File copyToIfNewer(Folder folder) {
        return null;
    }

    @Override
    protected InputStream getInputStream() {
        return this.classLoader.getResourceAsStream(FileValidationUtils.validateFilePath(this.path.toString().substring(1)));
    }
}

