/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.commons.io;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.springframework.util.Assert;

public abstract class FilteredIterator<E>
implements Iterator<E> {
    private final Iterator<E> sourceIterator;
    private E next;

    public FilteredIterator(Iterator<E> sourceIterator) {
        Assert.notNull(sourceIterator, (String)"SourceIterator must not be null");
        this.sourceIterator = sourceIterator;
    }

    @Override
    public boolean hasNext() {
        this.ensureNextHasBeenFetched();
        return this.next != null;
    }

    @Override
    public E next() {
        try {
            this.ensureNextHasBeenFetched();
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            E e = this.next;
            return e;
        }
        finally {
            this.next = null;
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private void ensureNextHasBeenFetched() {
        while (this.next == null && this.sourceIterator.hasNext()) {
            E candidate = this.sourceIterator.next();
            if (this.isElementFiltered(candidate)) continue;
            this.next = candidate;
        }
    }

    protected abstract boolean isElementFiltered(E var1);
}

