/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.commons.io;

import com.wavemaker.commons.io.File;
import com.wavemaker.commons.io.Folder;
import com.wavemaker.commons.io.Resource;
import com.wavemaker.commons.io.exception.ResourceTypeMismatchException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class ResourceURL {
    public static final String PROTOCOL = "rfs";

    private ResourceURL() {
    }

    public static URL get(Resource resource) throws MalformedURLException {
        return ResourceURL.get(resource, false);
    }

    public static URL get(Resource resource, boolean nonLocking) throws MalformedURLException {
        String spec = ResourceURL.getSpec(resource);
        ResourceURLStreamHandler handler = new ResourceURLStreamHandler(resource, nonLocking);
        return new URL(null, spec, handler);
    }

    public static List<URL> getForResources(Iterable<? extends Resource> resources) throws MalformedURLException {
        return ResourceURL.getForResources(resources, false);
    }

    public static List<URL> getForResources(Iterable<? extends Resource> resources, boolean nonLocking) throws MalformedURLException {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (Resource resource : resources) {
            urls.add(ResourceURL.get(resource, nonLocking));
        }
        return Collections.unmodifiableList(urls);
    }

    private static String getSpec(Resource resource) {
        return "rfs:" + resource;
    }

    private static class FileURLConnection
    extends URLConnection {
        private final File file;
        private final boolean nonLocking;

        public FileURLConnection(URL url, File file, boolean nonLocking) {
            super(url);
            this.file = file;
            this.nonLocking = nonLocking;
        }

        @Override
        public void connect() throws IOException {
        }

        @Override
        public InputStream getInputStream() throws IOException {
            if (this.nonLocking) {
                return new ByteArrayInputStream(this.file.getContent().asBytes());
            }
            return this.file.getContent().asInputStream();
        }
    }

    private static class ResourceURLStreamHandler
    extends URLStreamHandler {
        private final Folder root;
        private final boolean nonLocking;

        public ResourceURLStreamHandler(Resource resource, boolean nonLocking) {
            this.root = this.findRoot(resource);
            this.nonLocking = nonLocking;
        }

        @Override
        protected void parseURL(URL u, String spec, int start, int limit) {
            super.parseURL(u, spec, start, limit);
        }

        private Folder findRoot(Resource resource) {
            Resource rootResource = resource;
            while (rootResource.getParent() != null) {
                rootResource = rootResource.getParent();
            }
            return (Folder)rootResource;
        }

        @Override
        protected URLConnection openConnection(URL url) throws IOException {
            String path = url.getPath();
            try {
                File file = this.root.getFile(path);
                if (!file.exists()) {
                    throw new IOException("File '" + file + "' does not exist");
                }
                return new FileURLConnection(url, file, this.nonLocking);
            }
            catch (ResourceTypeMismatchException e) {
                throw new IOException("Unable to open URL connection to folder '" + path + "'", e);
            }
        }
    }
}

