/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.commons.io.local;

import com.wavemaker.commons.MessageResource;
import com.wavemaker.commons.ResourceAlreadyExistException;
import com.wavemaker.commons.io.File;
import com.wavemaker.commons.io.Folder;
import com.wavemaker.commons.io.JailedResourcePath;
import com.wavemaker.commons.io.Resource;
import com.wavemaker.commons.io.exception.ResourceDoesNotExistException;
import com.wavemaker.commons.io.exception.ResourceException;
import com.wavemaker.commons.io.exception.ResourceTypeMismatchException;
import com.wavemaker.commons.io.local.LocalFile;
import com.wavemaker.commons.io.local.LocalFolder;
import com.wavemaker.commons.io.store.FileStore;
import com.wavemaker.commons.io.store.FolderStore;
import com.wavemaker.commons.io.store.ResourceStore;
import com.wavemaker.commons.util.FileValidationUtils;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

abstract class LocalResourceStore
implements ResourceStore {
    private final java.io.File root;
    private final JailedResourcePath path;
    private final java.io.File file;

    public LocalResourceStore(java.io.File root, JailedResourcePath path) {
        Assert.notNull((Object)root, (String)"Root must not be null");
        Assert.notNull((Object)path, (String)"Path must not be null");
        if (root.exists()) {
            Assert.state((boolean)root.isDirectory(), (String)("The root '" + root + "' is not a folder"));
        }
        this.root = root;
        this.path = path;
        this.file = this.getFileForPath(path);
    }

    protected final java.io.File getRoot() {
        return this.root;
    }

    protected final java.io.File getFile() {
        return this.file;
    }

    protected final java.io.File getFileForPath(JailedResourcePath path) {
        return new java.io.File(this.getRoot(), FileValidationUtils.validateFilePath(path.getUnjailedPath().toString()));
    }

    @Override
    public JailedResourcePath getPath() {
        return this.path;
    }

    @Override
    public Resource getExisting(JailedResourcePath path) {
        int count = 0;
        while (true) {
            ++count;
            try {
                java.io.File resourceFile = this.getFileForPath(path);
                if (!resourceFile.exists()) {
                    return null;
                }
                return resourceFile.isDirectory() ? this.getFolder(path) : this.getFile(path);
            }
            catch (ResourceException e) {
                if (count != 3) continue;
                throw e;
            }
            break;
        }
    }

    @Override
    public Folder getFolder(JailedResourcePath path) {
        LocalFolderStore store = new LocalFolderStore(this.getRoot(), path);
        return new LocalFolder(store);
    }

    @Override
    public File getFile(JailedResourcePath path) {
        LocalFileStore store = new LocalFileStore(this.getRoot(), path);
        return new LocalFile(store);
    }

    @Override
    public Resource rename(String name) {
        java.io.File dest = new java.io.File(this.getFile().getParent(), name);
        JailedResourcePath destPath = this.getPath().getParent().get(name);
        if (!this.getFile().renameTo(dest)) {
            throw new ResourceException(MessageResource.create("com.wavemaker.commons.unable.to,rename.file"), this.getFile(), dest);
        }
        return this.getRenamedResource(destPath);
    }

    protected abstract Resource getRenamedResource(JailedResourcePath var1);

    @Override
    public boolean exists() {
        return this.file.exists();
    }

    @Override
    public void delete() {
        if (!this.file.delete() && this.file.exists()) {
            throw new ResourceException(MessageResource.create("com.wavemaker.commons.unable.to.delete.file"), this.file);
        }
    }

    @Override
    public int hashCode() {
        return this.getFile().hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LocalResourceStore other = (LocalResourceStore)obj;
        return ObjectUtils.nullSafeEquals((Object)this.getFile(), (Object)other.getFile());
    }

    static class LocalFolderStore
    extends LocalResourceStore
    implements FolderStore {
        public LocalFolderStore(java.io.File root, JailedResourcePath path) {
            super(root, path);
            if (this.exists() && !this.getFile().isDirectory()) {
                throw new ResourceTypeMismatchException(path.getUnjailedPath(), true);
            }
        }

        @Override
        protected Resource getRenamedResource(JailedResourcePath path) {
            return this.getFolder(path);
        }

        @Override
        public void create() {
            boolean created = this.getFile().mkdirs();
            if (!created && !this.exists()) {
                throw new ResourceException(MessageResource.create("com.wavemaker.commons.unable.to.create.folder"), this.getFile());
            }
        }

        @Override
        public Iterable<String> list() {
            java.io.File[] files = this.getFile().listFiles();
            if (files == null || files.length == 0) {
                return Collections.emptyList();
            }
            ArrayList<String> filenames = new ArrayList<String>(files.length);
            for (java.io.File file : files) {
                if (!file.exists()) continue;
                filenames.add(file.getName());
            }
            Collections.sort(filenames);
            return Collections.unmodifiableList(filenames);
        }
    }

    static class LocalFileStore
    extends LocalResourceStore
    implements FileStore {
        public LocalFileStore(java.io.File root, JailedResourcePath path) {
            super(root, path);
            if (this.exists() && !this.getFile().isFile()) {
                throw new ResourceTypeMismatchException(path.getUnjailedPath(), false);
            }
        }

        @Override
        protected Resource getRenamedResource(JailedResourcePath path) {
            LocalFileStore store = new LocalFileStore(this.getRoot(), path);
            return new LocalFile(store);
        }

        @Override
        public void create() {
            try {
                if (!this.getFile().createNewFile()) {
                    if (!this.getFile().exists()) {
                        throw new ResourceException(MessageResource.create("com.wavemaker.commons.unable.to.create.file"), this.getFile());
                    }
                    throw new ResourceAlreadyExistException(MessageResource.create("com.wavemaker.common.resource.exists"), this.getFile().getPath());
                }
            }
            catch (IOException e) {
                throw new ResourceException(e);
            }
        }

        @Override
        public InputStream getInputStream() {
            java.io.File file = this.getFile();
            try {
                return new BufferedInputStream(new FileInputStream(file));
            }
            catch (FileNotFoundException e) {
                throw new ResourceDoesNotExistException(file);
            }
        }

        @Override
        public OutputStream getOutputStream() {
            return this.getOutputStream(false);
        }

        @Override
        public OutputStream getOutputStream(boolean append) {
            try {
                return new FileOutputStream(this.getFile(), append);
            }
            catch (FileNotFoundException e) {
                throw new ResourceException(e);
            }
        }

        @Override
        public long getSize() {
            return this.getFile().length();
        }

        @Override
        public long getLastModified() {
            return this.getFile().lastModified();
        }

        @Override
        public void touch() {
            this.getFile().setLastModified(System.currentTimeMillis());
        }
    }
}

