/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.commons.io.store;

import com.wavemaker.commons.io.Folder;
import com.wavemaker.commons.io.JailedResourcePath;
import com.wavemaker.commons.io.Resource;
import com.wavemaker.commons.io.ResourceOperation;
import com.wavemaker.commons.io.ResourceStringFormat;
import com.wavemaker.commons.io.exception.ResourceDoesNotExistException;
import com.wavemaker.commons.io.store.ResourceStore;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.GenericTypeResolver;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public abstract class StoredResource
implements Resource {
    protected abstract ResourceStore getStore();

    protected final JailedResourcePath getPath() {
        return this.getStore().getPath();
    }

    protected final void ensureExists() {
        if (!this.exists()) {
            throw new ResourceDoesNotExistException(this);
        }
    }

    protected final void createParentIfMissing() {
        Folder parent = this.getParent(true);
        if (parent != null) {
            parent.createIfMissing();
        }
    }

    @Override
    public Folder getParent() {
        return this.getParent(false);
    }

    @Override
    public String getName() {
        return this.getPath().getPath().getName();
    }

    @Override
    public Resource rename(String name) {
        Assert.hasLength((String)name, (String)"Name must not be empty");
        Assert.isTrue((!name.contains("/") ? 1 : 0) != 0, (String)"Name must not contain path elements");
        this.ensureExists();
        Assert.state((this.getPath().getPath().getParent() != null ? 1 : 0) != 0, (String)"Root folders cannot be renamed");
        return this.getStore().rename(name);
    }

    @Override
    public boolean exists() {
        return this.getStore().exists();
    }

    @Override
    public String toString(ResourceStringFormat format) {
        return this.getPath().toString(format);
    }

    @Override
    public String toStringRelativeTo(Folder source) {
        Assert.notNull((Object)source, (String)"Source must not be null");
        return this.getPath().getPath().toStringRelativeTo(source.toString());
    }

    @Override
    public boolean isRelativeTo(Folder folder) {
        String relativePath = this.toStringRelativeTo(folder);
        return StringUtils.isNotBlank((CharSequence)relativePath);
    }

    @Override
    public <R extends Resource, O extends ResourceOperation<R>> O performOperation(O operation) {
        Class typeArgument = GenericTypeResolver.resolveTypeArgument(operation.getClass(), ResourceOperation.class);
        Assert.isInstanceOf((Class)typeArgument, (Object)this);
        operation.perform((StoredResource)this);
        return operation;
    }

    private Folder getParent(boolean unjailed) {
        JailedResourcePath path = this.getPath();
        JailedResourcePath parentPath = (unjailed ? path.unjail() : path).getParent();
        if (parentPath == null) {
            return null;
        }
        return this.getStore().getFolder(parentPath);
    }

    public int hashCode() {
        return this.getStore().hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StoredResource other = (StoredResource)obj;
        return ObjectUtils.nullSafeEquals((Object)this.getStore(), (Object)other.getStore());
    }

    @Override
    public String toString() {
        return this.toString(ResourceStringFormat.FULL);
    }

    @Override
    public boolean isModifiedAfter(long n) {
        return this.getLastModified() >= n;
    }

    @Override
    public boolean isModifiedAfter(Resource resource) {
        return this.getLastModified() >= resource.getLastModified();
    }

    @Override
    public long getLastModified() {
        return this.getStore().getFile(this.getPath()).getLastModified();
    }

    @Override
    public boolean isModifiedBefore(long n) {
        return this.getLastModified() <= n;
    }

    @Override
    public boolean isModifiedBefore(Resource resource) {
        return this.getLastModified() <= resource.getLastModified();
    }
}

