/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.commons.json.module;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import com.fasterxml.jackson.databind.ser.PropertyWriter;
import com.fasterxml.jackson.databind.ser.ResolvableSerializer;
import com.fasterxml.jackson.databind.ser.std.BeanSerializerBase;
import com.fasterxml.jackson.databind.util.NameTransformer;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CircularLoopHandlingSerializer<T>
extends JsonSerializer<T>
implements ResolvableSerializer,
ContextualSerializer {
    private static final Logger LOGGER = LoggerFactory.getLogger(CircularLoopHandlingSerializer.class);
    private static final ThreadLocal<Deque<Object>> objectReferenceStackTL = new ThreadLocal();
    private final BeanSerializerBase delegate;
    private final boolean failOnCircularReferences;

    public CircularLoopHandlingSerializer(BeanSerializerBase delegate, boolean failOnCircularReferences) {
        this.delegate = delegate;
        this.failOnCircularReferences = failOnCircularReferences;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serialize(T value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        LOGGER.debug("Serialization started for :{}", value.getClass());
        if (this.hasCyclicReference(value) && !this.delegate.usesObjectId()) {
            this.handleCyclicReference(gen, serializers);
            return;
        }
        this.notifyStartSerialization(value);
        try {
            this.delegate.serialize(value, gen, serializers);
        }
        finally {
            LOGGER.debug("Serialization completed for:{}", value.getClass());
            this.notifyEndSerialization();
        }
    }

    public JsonSerializer<?> createContextual(SerializerProvider prov, BeanProperty property) throws JsonMappingException {
        JsonSerializer contextual = this.delegate.createContextual(prov, property);
        return this.wrapIfNeeded(contextual);
    }

    public void resolve(SerializerProvider provider) throws JsonMappingException {
        this.delegate.resolve(provider);
    }

    public JsonSerializer<T> unwrappingSerializer(NameTransformer unwrapper) {
        return this.wrapIfNeeded(this.delegate.unwrappingSerializer(unwrapper));
    }

    public JsonSerializer<T> replaceDelegatee(JsonSerializer<?> delegatee) {
        return this.wrapIfNeeded(this.delegate.replaceDelegatee(delegatee));
    }

    public JsonSerializer<?> withFilterId(Object filterId) {
        return this.wrapIfNeeded((JsonSerializer)this.delegate.withFilterId(filterId));
    }

    public void serializeWithType(T value, JsonGenerator gen, SerializerProvider serializers, TypeSerializer typeSer) throws IOException {
        this.delegate.serializeWithType(value, gen, serializers, typeSer);
    }

    public Class<T> handledType() {
        return this.delegate.handledType();
    }

    public boolean isEmpty(T value) {
        return this.delegate.isEmpty(value);
    }

    public boolean isEmpty(SerializerProvider provider, T value) {
        return this.delegate.isEmpty(provider, value);
    }

    public boolean usesObjectId() {
        return this.delegate.usesObjectId();
    }

    public boolean isUnwrappingSerializer() {
        return this.delegate.isUnwrappingSerializer();
    }

    public JsonSerializer<?> getDelegatee() {
        return this.delegate.getDelegatee();
    }

    public Iterator<PropertyWriter> properties() {
        return this.delegate.properties();
    }

    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType type) throws JsonMappingException {
        this.delegate.acceptJsonFormatVisitor(visitor, type);
    }

    public void notifyStartSerialization(Object value) {
        this.getObjectRefStack().push(value);
    }

    public void notifyEndSerialization() {
        this.getObjectRefStack().pop();
        if (this.getObjectRefStack().isEmpty()) {
            objectReferenceStackTL.remove();
        }
    }

    public boolean hasCyclicReference(Object value) {
        return !this.getObjectRefStack().isEmpty() && !this.getObjectRefStack().getFirst().equals(value) && this.getObjectRefStack().contains(value);
    }

    public void handleCyclicReference(JsonGenerator jgen, SerializerProvider provider) throws IOException {
        String refStack = this.printableRefStack();
        if (this.failOnCircularReferences) {
            throw new JsonMappingException((Closeable)jgen, "Cyclic-reference leading to cycle, Object Reference Stack:" + refStack);
        }
        provider.defaultSerializeValue(null, jgen);
    }

    private String printableRefStack() {
        StringBuilder sb = new StringBuilder();
        Object[] objects = this.getObjectRefStack().toArray();
        for (int i = objects.length - 1; i >= 0; --i) {
            sb.append(objects[i].getClass().getSimpleName());
            if (i <= 0) continue;
            sb.append("->");
        }
        return sb.toString();
    }

    private Deque<Object> getObjectRefStack() {
        if (objectReferenceStackTL.get() == null) {
            objectReferenceStackTL.set(new ArrayDeque());
        }
        return objectReferenceStackTL.get();
    }

    private JsonSerializer wrapIfNeeded(JsonSerializer serializer) {
        return serializer instanceof BeanSerializerBase ? new CircularLoopHandlingSerializer<T>((BeanSerializerBase)serializer, this.failOnCircularReferences) : serializer;
    }
}

