/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.commons.pattern;

import com.wavemaker.commons.pattern.DirectoryURLPattern;
import com.wavemaker.commons.pattern.ExactURLPattern;
import com.wavemaker.commons.pattern.ExtensionURLPattern;

public abstract class URLPattern {
    private final String patternString;

    public static URLPattern constructPattern(String requestPattern) {
        if (requestPattern.endsWith("/*")) {
            return new DirectoryURLPattern(requestPattern);
        }
        if (requestPattern.startsWith("*.")) {
            return new ExtensionURLPattern(requestPattern);
        }
        return new ExactURLPattern(requestPattern);
    }

    protected URLPattern(String pattern) {
        this.patternString = pattern;
    }

    public String getPatternString() {
        return this.patternString;
    }

    public abstract boolean matches(String var1);
}

