/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.commons.properties;

import com.wavemaker.commons.MessageResource;
import com.wavemaker.commons.WMRuntimeException;
import com.wavemaker.commons.properties.SortedProperties;
import com.wavemaker.commons.util.WMIOUtils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.lang3.StringUtils;

public class PropertiesWriter {
    private Properties properties;
    private String comments;
    private boolean sortProperties;
    private boolean sansDate;
    private boolean toXML;
    private static final String OBJECT_CANNOT_BE_NULL = "com.wavemaker.commons.object.can.not.be.null";

    public PropertiesWriter(Properties properties) {
        this.properties = properties;
        this.init();
    }

    public static PropertiesWriter newWriter(Properties properties) {
        return new PropertiesWriter(properties);
    }

    private void init() {
        if (this.properties == null) {
            throw new WMRuntimeException(MessageResource.create(OBJECT_CANNOT_BE_NULL), "properties");
        }
    }

    public PropertiesWriter setComments(String comments) {
        this.comments = comments;
        return this;
    }

    public PropertiesWriter setSortProperties(boolean sortProperties) {
        this.sortProperties = sortProperties;
        return this;
    }

    public PropertiesWriter setSansDate(boolean sansDate) {
        this.sansDate = sansDate;
        return this;
    }

    public PropertiesWriter setToXML(boolean toXML) {
        this.toXML = toXML;
        return this;
    }

    public synchronized void write(File file) throws FileNotFoundException {
        if (file == null) {
            throw new WMRuntimeException(MessageResource.create(OBJECT_CANNOT_BE_NULL), "file");
        }
        this.write(new BufferedOutputStream(new FileOutputStream(file)));
    }

    public synchronized void write(com.wavemaker.commons.io.File file) {
        this.write(file.getContent().asOutputStream());
    }

    public synchronized void write(OutputStream stream) {
        if (stream == null) {
            throw new WMRuntimeException(MessageResource.create(OBJECT_CANNOT_BE_NULL), "Output Stream");
        }
        this.sort();
        if (this.toXML) {
            this.storeToXml(stream);
        } else if (this.sansDate) {
            this.storeSansDate(stream);
        } else {
            this.storeProperties(stream);
        }
    }

    protected Properties sort() {
        if (this.sortProperties) {
            SortedProperties sortedProperties = new SortedProperties();
            sortedProperties.putAll((Map<?, ?>)this.properties);
            this.properties = sortedProperties;
        }
        return this.properties;
    }

    protected void storeProperties(OutputStream outputStream) {
        try {
            this.properties.store(outputStream, this.comments);
        }
        catch (IOException e) {
            throw new WMRuntimeException(MessageResource.create("com.wavemaker.commons.failed.to.store.properties"), (Throwable)e);
        }
        finally {
            WMIOUtils.closeSilently(outputStream);
        }
    }

    protected void storeToXml(OutputStream os) {
        try {
            this.properties.storeToXML(os, this.comments, "UTF-8");
        }
        catch (IOException e) {
            throw new WMRuntimeException(MessageResource.create("com.wavemaker.commons.properties.file.write.failure"), (Throwable)e);
        }
        finally {
            WMIOUtils.closeSilently(os);
        }
    }

    protected void storeSansDate(OutputStream os) {
        PropertiesConfiguration configuration = new PropertiesConfiguration();
        configuration.getLayout().setGlobalSeparator("=");
        Enumeration<Object> enumeration = this.properties.keys();
        boolean canComment = true;
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            if (canComment && StringUtils.isNotBlank((CharSequence)this.comments)) {
                configuration.getLayout().setComment(key, this.comments);
                canComment = false;
            }
            configuration.setProperty(key, this.properties.get(key));
        }
        try {
            configuration.getLayout().save(configuration, (Writer)new OutputStreamWriter(os));
        }
        catch (ConfigurationException e) {
            throw new WMRuntimeException(MessageResource.create("com.wavemaker.commons.properties.file.write.failure"), (Throwable)e);
        }
        finally {
            WMIOUtils.closeSilently(os);
        }
        configuration.clear();
    }
}

