/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.commons.properties;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadLocalSystemProperties
extends Properties {
    private static final ThreadLocal<Properties> THREAD_LOCAL_PROPERTIES = new ThreadLocal();
    private static final Properties VM_LEVEL_PROPERTIES = System.getProperties();
    private static final ThreadLocalSystemProperties INSTANCE = new ThreadLocalSystemProperties();
    private static final Logger logger = LoggerFactory.getLogger(ThreadLocalSystemProperties.class);

    private ThreadLocalSystemProperties() {
        super(VM_LEVEL_PROPERTIES);
    }

    public synchronized ThreadLocalSystemProperties enable() {
        Properties currentSystemProperties = System.getProperties();
        if (currentSystemProperties instanceof ThreadLocalSystemProperties) {
            logger.info("ThreadLocal based Properties is already set for System Properties");
        } else {
            logger.info("Setting ThreadLocal based Properties for System.setProperties");
            System.setProperties(INSTANCE);
            logger.info("Set ThreadLocal based Properties for System.setProperties!!");
        }
        return INSTANCE;
    }

    public synchronized void disable() {
        Properties currentSystemProperties = System.getProperties();
        if (currentSystemProperties instanceof ThreadLocalSystemProperties) {
            logger.info("Removing ThreadLocal based Properties for System.setProperties");
            System.setProperties(VM_LEVEL_PROPERTIES);
            logger.info("Removed ThreadLocal based Properties for System.setProperties");
        } else {
            logger.warn("ThreadLocal based Properties is not enabled for System.setProperties");
        }
    }

    public static synchronized void executeInThreadLocalSystemProperties(Runnable runnable) {
        try {
            INSTANCE.record();
            runnable.run();
        }
        finally {
            INSTANCE.stop();
        }
    }

    private synchronized void record() {
        Properties currentSystemProperties = System.getProperties();
        if (currentSystemProperties instanceof ThreadLocalSystemProperties) {
            Properties threadLocalProperties = ThreadLocalSystemProperties.getLocalProperties();
            if (threadLocalProperties instanceof ThreadLocalSystemProperties) {
                logger.info("Usage of Thread Local properties for current thread is already enabled");
            } else {
                logger.info("Enabling usage of Thread Local properties for current thread");
                THREAD_LOCAL_PROPERTIES.set(new Properties(VM_LEVEL_PROPERTIES));
                logger.info("Enabled usage of Thread Local properties for current thread");
            }
        } else {
            throw new IllegalStateException("Request for recording ThreadLocal for current thread without enabling the ThreadLocalSystemProperties");
        }
    }

    private synchronized void stop() {
        Properties currentSystemProperties = System.getProperties();
        if (!(currentSystemProperties instanceof ThreadLocalSystemProperties)) {
            throw new IllegalStateException("Request for stopping ThreadLocal for current thread without enabling the ThreadLocalSystemProperties");
        }
        logger.info("Disabling usage of Thread Local properties for current thread");
        THREAD_LOCAL_PROPERTIES.remove();
        logger.info("Disabled usage of Thread Local properties for current thread");
    }

    @Override
    public String getProperty(String key) {
        return ThreadLocalSystemProperties.getLocalProperties().getProperty(key);
    }

    @Override
    public String getProperty(String key, String defaultValue) {
        return ThreadLocalSystemProperties.getLocalProperties().getProperty(key, defaultValue);
    }

    @Override
    public Object setProperty(String key, String value) {
        return ThreadLocalSystemProperties.getLocalProperties().setProperty(key, value);
    }

    @Override
    public Enumeration<?> propertyNames() {
        return ThreadLocalSystemProperties.getLocalProperties().propertyNames();
    }

    @Override
    public Set<String> stringPropertyNames() {
        return ThreadLocalSystemProperties.getLocalProperties().stringPropertyNames();
    }

    @Override
    public void list(PrintStream out) {
        ThreadLocalSystemProperties.getLocalProperties().list(out);
    }

    @Override
    public void list(PrintWriter out) {
        ThreadLocalSystemProperties.getLocalProperties().list(out);
    }

    @Override
    public Set<Object> keySet() {
        Properties localProperties = ThreadLocalSystemProperties.getLocalProperties();
        if (localProperties == VM_LEVEL_PROPERTIES) {
            return localProperties.keySet();
        }
        return this.entrySet().stream().map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    @Override
    public Set<Object> values() {
        Properties localProperties = ThreadLocalSystemProperties.getLocalProperties();
        if (localProperties == VM_LEVEL_PROPERTIES) {
            return localProperties.keySet();
        }
        return this.entrySet().stream().map(Map.Entry::getValue).collect(Collectors.toSet());
    }

    @Override
    public int size() {
        Properties localProperties = ThreadLocalSystemProperties.getLocalProperties();
        if (localProperties == VM_LEVEL_PROPERTIES) {
            return localProperties.size();
        }
        return this.entrySet().size();
    }

    @Override
    public Set<Map.Entry<Object, Object>> entrySet() {
        Properties localProperties = ThreadLocalSystemProperties.getLocalProperties();
        if (localProperties == VM_LEVEL_PROPERTIES) {
            return localProperties.entrySet();
        }
        Set<Map.Entry<Object, Object>> parentEntries = VM_LEVEL_PROPERTIES.entrySet();
        Set<Map.Entry<Object, Object>> childEntries = localProperties.entrySet();
        HashMap entrySetMap = new HashMap(parentEntries.size());
        parentEntries.forEach((? super T entry) -> entrySetMap.put(entry.getKey(), entry));
        childEntries.forEach((? super T entry) -> entrySetMap.put(entry.getKey(), entry));
        return Collections.unmodifiableSet(new HashSet(entrySetMap.values()));
    }

    private static Properties getLocalProperties() {
        Properties threadLocalProperties = THREAD_LOCAL_PROPERTIES.get();
        if (threadLocalProperties == null) {
            threadLocalProperties = VM_LEVEL_PROPERTIES;
        }
        return threadLocalProperties;
    }
}

