/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.commons.util;

import com.wavemaker.commons.WMRuntimeException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public abstract class ConversionUtils {
    private ConversionUtils() {
    }

    public static List<File> convertToFileList(List<Resource> resources) {
        ArrayList<File> files = new ArrayList<File>();
        for (Resource resource : resources) {
            try {
                files.add(resource.getFile());
            }
            catch (IOException ex) {
                throw new WMRuntimeException(ex);
            }
        }
        return files;
    }

    public static List<Resource> convertToResourceList(List<File> files) {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        for (File file : files) {
            Object path = file.getAbsolutePath();
            if (file.isDirectory() && !((String)path).endsWith("/")) {
                path = (String)path + "/";
            }
            resources.add((Resource)new FileSystemResource((String)path));
        }
        return resources;
    }
}

