/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.commons.util;

import com.wavemaker.commons.MessageResource;
import com.wavemaker.commons.WMRuntimeException;
import com.wavemaker.commons.core.web.rest.ErrorResponse;
import com.wavemaker.commons.core.web.rest.ErrorResponses;
import com.wavemaker.commons.json.JSONUtils;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class HttpRequestUtils {
    private HttpRequestUtils() {
    }

    public static void writeJsonErrorResponse(MessageResource messageResource, int responseCode, HttpServletResponse response) throws IOException {
        ErrorResponse errorResponse = HttpRequestUtils.getErrorResponse(messageResource);
        HttpRequestUtils.writeErrorResponse(responseCode, response, errorResponse);
    }

    public static void writeJsonErrorResponse(String message, int responseCode, HttpServletResponse response) throws IOException {
        ErrorResponse errorResponse = HttpRequestUtils.getErrorResponse(message);
        HttpRequestUtils.writeErrorResponse(responseCode, response, errorResponse);
    }

    private static void writeErrorResponse(int responseCode, HttpServletResponse response, ErrorResponse errorResponse) throws IOException {
        HashMap<String, ErrorResponses> errorMap = new HashMap<String, ErrorResponses>(1);
        ArrayList<ErrorResponse> errorResponseList = new ArrayList<ErrorResponse>(1);
        errorResponseList.add(errorResponse);
        errorMap.put("errors", new ErrorResponses(errorResponseList));
        response.setStatus(responseCode);
        response.setContentType("application/json");
        response.getWriter().write(JSONUtils.toJSON(errorMap));
    }

    private static ErrorResponse getErrorResponse(String message) {
        ErrorResponse errorResponse = new ErrorResponse();
        errorResponse.setMessage(message);
        return errorResponse;
    }

    private static ErrorResponse getErrorResponse(MessageResource messageResource) {
        ErrorResponse errorResponse = new ErrorResponse();
        errorResponse.setMessageKey(messageResource.getMessageKey());
        errorResponse.setMessage(messageResource.getMessageWithPlaceholders());
        errorResponse.setParameters(new ArrayList<String>(0));
        return errorResponse;
    }

    public static String getBaseUrl(String requestUrl) {
        if (Objects.nonNull(requestUrl)) {
            try {
                URI uri = new URI(requestUrl);
                return HttpRequestUtils.getBaseUrl(uri);
            }
            catch (URISyntaxException e) {
                throw new WMRuntimeException(MessageResource.create("com.wavemaker.commons.invalid.request.url"), (Throwable)e);
            }
        }
        return null;
    }

    public static String getBaseUrl(URI uri) {
        StringBuilder stringBuilder = new StringBuilder(uri.getScheme()).append("://").append(uri.getHost());
        int serverPort = uri.getPort();
        if (serverPort != 80 && serverPort != 443 && serverPort != -1) {
            stringBuilder.append(":").append(serverPort).toString();
        }
        return stringBuilder.toString();
    }

    public static String getBaseUrl(HttpServletRequest httpServletRequest) {
        StringBuilder sb = new StringBuilder(httpServletRequest.getScheme()).append("://").append(httpServletRequest.getServerName());
        int serverPort = httpServletRequest.getServerPort();
        if (serverPort != 80 && serverPort != 443) {
            sb.append(":").append(serverPort).toString();
        }
        return sb.toString();
    }

    public static boolean isRequestedFromIEBrowser(HttpServletRequest httpServletRequest) {
        String userAgent = httpServletRequest.getHeader("User-Agent");
        return userAgent != null && (userAgent.contains("MSIE") || userAgent.contains("rv") && userAgent.contains("Trident"));
    }

    public static String getApplicationBaseUrl(HttpServletRequest httpServletRequest) {
        return HttpRequestUtils.getBaseUrl(httpServletRequest) + httpServletRequest.getContextPath();
    }

    public static boolean isAjaxRequest(HttpServletRequest request) {
        return "XMLHttpRequest".equals(request.getHeader("X-Requested-With"));
    }
}

