/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.commons.util;

import com.wavemaker.commons.MessageResource;
import com.wavemaker.commons.WMRuntimeException;
import com.wavemaker.commons.classloader.ClassLoaderUtils;
import com.wavemaker.commons.util.ObjectAccess;
import com.wavemaker.commons.util.StringUtils;
import com.wavemaker.commons.util.TypeConversionUtils;
import java.util.ArrayList;
import java.util.List;

public class ObjectLiteralParser {
    private final ObjectAccess objectAccess = ObjectAccess.getInstance();
    private final Class<?> type;
    private final String literal;

    public ObjectLiteralParser(String literal, String type) {
        this(literal, ClassLoaderUtils.loadClass(type, false));
    }

    public ObjectLiteralParser(String literal, Class<?> type) {
        if (literal == null) {
            throw new IllegalArgumentException("literal cannot be null");
        }
        if (type == null) {
            throw new IllegalArgumentException("type cannot be null");
        }
        this.literal = StringUtils.unquote(literal.trim());
        this.type = type;
    }

    public Object parse() {
        return this.buildObjectGraph(0, this.type);
    }

    private Object buildObjectGraph(int start, Class<?> type) {
        if (this.literal.charAt(start) == '[') {
            return this.buildList(start, type);
        }
        Object rtn = this.objectAccess.newInstance(type);
        StringBuilder propertyName = new StringBuilder();
        boolean isPropertyName = true;
        StringBuilder strValue = new StringBuilder();
        Object value = null;
        int nesting = 0;
        for (int i = start + 1; i < this.literal.length(); ++i) {
            boolean shouldSetProperty;
            char c = this.literal.charAt(i);
            if (c == '{') {
                if (nesting == 0) {
                    String s = propertyName.toString().trim();
                    Class<?> t = this.getPropertyType(type, s);
                    value = this.buildObjectGraph(i, t);
                }
                ++nesting;
            } else if (c == '}') {
                if (nesting == 1) {
                    start = i + 1;
                }
                --nesting;
            } else if (c == ':' && nesting == 0) {
                isPropertyName = false;
            } else if (c != ',' && nesting == 0) {
                if (isPropertyName) {
                    propertyName.append(c);
                } else {
                    strValue.append(c);
                }
            }
            boolean done = nesting == -1 && c == '}';
            boolean bl = shouldSetProperty = nesting == 0 && c == ',' || done;
            if (shouldSetProperty) {
                String propName;
                if (strValue.length() > 0) {
                    if (value != null) {
                        throw new AssertionError((Object)"value should be null");
                    }
                    value = strValue.toString().trim();
                }
                if ((propName = StringUtils.unquote(propertyName.toString().trim())).length() != 0) {
                    this.setProperty(rtn, propName, value);
                }
                isPropertyName = true;
                propertyName.delete(0, propertyName.length());
                strValue.delete(0, strValue.length());
                value = null;
            }
            if (!done) continue;
            return rtn;
        }
        throw new WMRuntimeException(MessageResource.create("com.wavemaker.commons.mismatched.braces"), this.literal);
    }

    private Class<?> getPropertyType(Class<?> clazz, String propertyName) {
        Class<?> rtn = this.objectAccess.getPropertyType(clazz, propertyName);
        if (rtn == null) {
            throw new WMRuntimeException(MessageResource.create("com.wavemaker.commons.invalid.property"), clazz.getName(), propertyName);
        }
        return rtn;
    }

    private void setProperty(Object o, String propertyName, Object value) {
        if (value instanceof String) {
            String strValue = (String)value;
            strValue = StringUtils.unquote(strValue);
            Class<?> t = this.getPropertyType(o.getClass(), propertyName);
            value = TypeConversionUtils.fromString(t, strValue);
        }
        this.objectAccess.setProperty(o, propertyName, value);
    }

    private List<Object> buildList(int start, Class<?> type) {
        int i = start;
        if (this.literal.charAt(i) != '[') {
            throw new IllegalArgumentException("List must start with '['");
        }
        int j = this.literal.indexOf(93, i + 1);
        if (j == -1) {
            throw new IllegalArgumentException("List must end with ']'");
        }
        ArrayList<Object> rtn = new ArrayList<Object>();
        String s = this.literal.substring(i + 1, j);
        for (String token : s.split(",")) {
            Object o = TypeConversionUtils.fromString(type, token.trim());
            rtn.add(o);
        }
        return rtn;
    }
}

