/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.commons.util;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringTemplate {
    private static final int KEY_GROUP = 2;
    private static final int OPTIONAL_VALUE_GROUP = 4;
    private static final Pattern KEY_PATTERN = Pattern.compile("\\$\\{(([^}\\[]+)(\\[([^\\]]+)\\])?)\\}");
    private final Matcher matcher;
    private final boolean blankIfNull;

    public StringTemplate(String template, boolean blankIfNull) {
        this.matcher = KEY_PATTERN.matcher(template);
        this.blankIfNull = blankIfNull;
    }

    public StringTemplate(String template) {
        this(template, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String substitute(Map<String, ?> map) {
        Matcher matcher = this.matcher;
        synchronized (matcher) {
            this.matcher.reset();
            StringBuffer sb = new StringBuffer();
            while (this.matcher.find()) {
                String replacement = this.findReplacement(map);
                this.matcher.appendReplacement(sb, Matcher.quoteReplacement(replacement));
            }
            this.matcher.appendTail(sb);
            return sb.toString();
        }
    }

    private String findReplacement(Map<String, ?> map) {
        String keyWithPlaceHolder = this.matcher.group();
        String key = this.matcher.group(2);
        String optionalValue = this.matcher.group(4);
        Object value = map.get(key);
        String replacement = "";
        if (value == null) {
            if (optionalValue == null) {
                replacement = this.blankIfNull ? "" : keyWithPlaceHolder;
            }
        } else if (optionalValue == null) {
            replacement = value.toString();
        } else {
            StringTemplate subStringTemplate = new StringTemplate(optionalValue, this.blankIfNull);
            replacement = subStringTemplate.substitute(map);
        }
        return replacement;
    }
}

