/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.commons.util.concurrent;

import com.wavemaker.commons.SemaphoreAcquisitionTimeoutException;
import com.wavemaker.commons.ThreadInterruptedException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WMSemaphore {
    private Semaphore semaphore;
    private static final Logger logger = LoggerFactory.getLogger(WMSemaphore.class);
    private String name;
    private int totalPermits;

    public WMSemaphore(String name, int permits) {
        this(name, permits, true);
    }

    public WMSemaphore(String name, int totalPermits, boolean fair) {
        this.semaphore = new Semaphore(totalPermits, fair);
        this.name = name;
        this.totalPermits = totalPermits;
    }

    public void acquire(int timeout, TimeUnit unit) {
        this.acquire(1, timeout, unit);
    }

    public void acquire(int permits, int timeout, TimeUnit unit) {
        try {
            logger.info("Trying to acquire {} permit(s) in semaphore {}", (Object)permits, (Object)this);
            boolean acquired = this.semaphore.tryAcquire(permits, timeout, unit);
            logger.info("Acquisition status is {} while acquiring {} permit(s) in semaphore {}", new Object[]{acquired, permits, this});
            if (!acquired) {
                throw new SemaphoreAcquisitionTimeoutException();
            }
        }
        catch (InterruptedException e) {
            this.handleInterruptedException(e);
        }
    }

    public void release() {
        this.release(1);
    }

    public void release(int permits) {
        this.semaphore.release(permits);
        logger.info("Released {} permit(s) in semaphore {}", (Object)permits, (Object)this);
    }

    private void handleInterruptedException(InterruptedException e) {
        logger.info("Received interrupted exception in thread {} in semaphore {}", (Object)Thread.currentThread().getName(), (Object)this);
        Thread.currentThread().interrupt();
        throw new ThreadInterruptedException(e);
    }

    public String toString() {
        return "WMSemaphore{ availablePermits=" + this.semaphore.availablePermits() + ", totalPermits=" + this.totalPermits + ", name='" + this.name + "'}";
    }
}

