/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.commons.web.filter;

import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.web.filter.ShallowEtagHeaderFilter;

public class EtagFilter
extends ShallowEtagHeaderFilter {
    public static final String SKIP_ETAG = "skipEtag";
    private static final Logger etagFilterLogger = LoggerFactory.getLogger(EtagFilter.class);

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        boolean clientSupportsEtag = this.doesClientSupportEtag(request);
        if (HttpMethod.GET.name().equals(request.getMethod()) && clientSupportsEtag) {
            etagFilterLogger.debug("Setting Etag header for request for url {}, user-agent {}", (Object)request.getRequestURL(), (Object)request.getHeader("User-Agent"));
            response.setHeader("Cache-Control", "max-age=0");
            super.doFilterInternal(request, response, filterChain);
        } else {
            if (!clientSupportsEtag) {
                etagFilterLogger.debug("Client doesn't support Etag headers for request url {}, user-agent {}", (Object)request.getRequestURL(), (Object)request.getHeader("User-Agent"));
                response.setHeader("Cache-Control", "no-cache, no-store, must-revalidate");
                response.setHeader("Pragma", "no-cache");
                response.setDateHeader("Expires", 0L);
            }
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }

    protected boolean shouldNotFilter(HttpServletRequest request) throws ServletException {
        return Objects.equals(request.getAttribute(SKIP_ETAG), true);
    }

    protected boolean isEligibleForEtag(HttpServletRequest request, HttpServletResponse response, int responseStatusCode, InputStream inputStream) {
        return responseStatusCode >= 200 && responseStatusCode < 300 && HttpMethod.GET.name().equals(request.getMethod());
    }

    protected boolean doesClientSupportEtag(HttpServletRequest request) {
        return true;
    }
}

