/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.commons.zip;

import com.wavemaker.commons.io.File;
import com.wavemaker.commons.io.Folder;
import com.wavemaker.commons.io.Resource;
import com.wavemaker.commons.io.Resources;
import com.wavemaker.commons.zip.DynamicZipInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashSet;
import java.util.Set;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

class ZipResourcesStream
extends FilterInputStream {
    private final Folder source;
    private final String prefix;

    public ZipResourcesStream(Resources<?> resources, String prefix) {
        super(null);
        Assert.notNull(resources, (String)"Resources must not be null");
        this.source = resources.getSource();
        this.prefix = this.fixupPrefix(prefix);
        LinkedHashSet<DynamicZipInputStream.Entry> entries = new LinkedHashSet<DynamicZipInputStream.Entry>();
        for (Resource resource : resources) {
            this.addToEntries(entries, resource);
        }
        this.in = new DynamicZipInputStream(entries);
    }

    private String fixupPrefix(String prefix) {
        if (!StringUtils.hasLength((String)prefix)) {
            return "";
        }
        if (!prefix.endsWith("/")) {
            return prefix + "/";
        }
        return prefix;
    }

    private void addToEntries(Set<DynamicZipInputStream.Entry> entries, Resource resource) {
        Folder parent = resource.getParent();
        if (parent != null && !parent.equals(this.source)) {
            this.addToEntries(entries, resource.getParent());
        }
        entries.add(new ResourceEntry(resource));
    }

    private class ResourceEntry
    implements DynamicZipInputStream.Entry {
        private final Resource resource;

        public ResourceEntry(Resource resource) {
            this.resource = resource;
        }

        @Override
        public String getName() {
            return ZipResourcesStream.this.prefix + this.resource.toString().substring(ZipResourcesStream.this.source.toString().length());
        }

        @Override
        public InputStream getInputStream() throws IOException {
            if (this.resource instanceof File) {
                return ((File)this.resource).getContent().asInputStream();
            }
            return null;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (obj instanceof ResourceEntry) {
                return ((ResourceEntry)obj).getName().equals(this.getName());
            }
            return false;
        }

        public int hashCode() {
            return this.getName().hashCode();
        }
    }
}

