/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.commons;

import com.wavemaker.commons.MessageResource;
import com.wavemaker.commons.MessageResourceHolder;
import com.wavemaker.commons.WMCommonException;

public class WMRuntimeException
extends RuntimeException
implements WMCommonException {
    private MessageResourceHolder messageResourceHolder = new MessageResourceHolder();

    public WMRuntimeException(String message) {
        this.messageResourceHolder.setMessage(message);
    }

    public WMRuntimeException(MessageResource resource) {
        this.messageResourceHolder.setMessageResource(resource);
    }

    public WMRuntimeException(MessageResource resource, Throwable cause, Object ... args) {
        this(cause);
        this.messageResourceHolder.setMessageResource(resource);
        this.messageResourceHolder.setArgs(args);
    }

    public WMRuntimeException(MessageResource resource, String detailedMessage, Throwable cause, Object ... args) {
        this(resource, cause, args);
        this.messageResourceHolder.setMessage(detailedMessage);
    }

    public WMRuntimeException(MessageResource resource, Throwable cause) {
        this(resource, cause, null);
    }

    public WMRuntimeException(MessageResource resource, String detailedMessage, Throwable cause) {
        this(resource, detailedMessage, cause, null);
    }

    public WMRuntimeException(MessageResource resource, Object ... args) {
        this.messageResourceHolder.setArgs(args);
        this.messageResourceHolder.setMessageResource(resource);
    }

    public WMRuntimeException() {
    }

    public WMRuntimeException(Throwable cause) {
        super(cause);
    }

    public WMRuntimeException(String message, Throwable cause) {
        super(message, cause);
        this.messageResourceHolder.setMessage(message);
    }

    @Override
    public MessageResourceHolder getMessageResourceHolder() {
        return this.messageResourceHolder;
    }

    @Override
    public String getMessage() {
        MessageResource messageResource = this.messageResourceHolder.getMessageResource();
        String message = messageResource != null ? messageResource.getMessage(this.messageResourceHolder.getArgs()) : this.messageResourceHolder.getMessage();
        return message == null ? "" : message;
    }
}

