/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.commons.auth.oauth2;

import com.wavemaker.commons.MessageResource;
import com.wavemaker.commons.WMRuntimeException;
import com.wavemaker.commons.auth.oauth2.OAuth2ProviderConfig;
import com.wavemaker.commons.auth.oauth2.Scope;
import com.wavemaker.commons.auth.oauth2.extractors.AccessTokenRequestContext;
import com.wavemaker.commons.auth.oauth2.extractors.AccessTokenResponseExtractor;
import com.wavemaker.commons.io.ClassPathFile;
import com.wavemaker.commons.json.JSONUtils;
import java.io.IOException;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringSubstitutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuth2Helper {
    private static final String OAUTH_CALLBACK_URL_RESPONSE = "templates/oauth2/oauth_callback_url_response.ftl";
    private static final Logger logger = LoggerFactory.getLogger(OAuth2Helper.class);
    private static AccessTokenResponseExtractor accessTokenResponseExtractor = new AccessTokenResponseExtractor();

    private OAuth2Helper() {
    }

    public static String getAuthorizationUrl(OAuth2ProviderConfig oAuth2ProviderConfig, String redirectUrl, String state) {
        String scope = OAuth2Helper.getScopeValue(oAuth2ProviderConfig);
        String encodedState = new String(Base64.getEncoder().encode(state.getBytes()));
        String authorizationUrl = oAuth2ProviderConfig.getAuthorizationUrl();
        String queryParamDelimiter = authorizationUrl.contains("?") ? "&" : "?";
        StringBuilder sb = new StringBuilder(authorizationUrl).append(queryParamDelimiter).append("client_id").append("=").append(oAuth2ProviderConfig.getClientId()).append("&").append("redirect_uri").append("=").append(redirectUrl).append("&").append("response_type").append("=code").append("&").append("state").append("=").append(encodedState);
        if (StringUtils.isNotBlank((CharSequence)scope)) {
            sb.append("&").append("scope").append("=").append(scope);
        }
        return sb.toString();
    }

    public static Map<String, String> getStateObject(String stateParameter) {
        String stateParam = new String(Base64.getDecoder().decode(stateParameter));
        try {
            return JSONUtils.toObject(stateParam, Map.class);
        }
        catch (IOException e) {
            throw new WMRuntimeException(e);
        }
    }

    public static String getStateParameterValue(Map<String, String> stateObject) {
        String stateParameter = JSONUtils.toJSON(stateObject);
        return new String(Base64.getEncoder().encode(stateParameter.getBytes()));
    }

    public static String getAccessTokenApiRequestBody(OAuth2ProviderConfig oAuth2ProviderConfig, String code, String redirectUri) {
        return "client_id" + "=" + oAuth2ProviderConfig.getClientId() + "&" + "client_secret" + "=" + oAuth2ProviderConfig.getClientSecret() + "&" + "code" + "=" + code + "&" + "redirect_uri" + "=" + redirectUri + "&" + "grant_type" + "=authorization_code";
    }

    public static String extractAccessToken(AccessTokenRequestContext accessTokenRequestContext) {
        logger.debug("AuthorizationServerResponse for get token api is {}", (Object)accessTokenRequestContext.getResponseBody());
        String accessToken = accessTokenResponseExtractor.getAccessToken(accessTokenRequestContext);
        if (accessToken == null) {
            throw new WMRuntimeException(MessageResource.create("com.wavemaker.commons.AccessTokenResponseExtractor.not.found"), accessTokenRequestContext.getMediaType());
        }
        return accessToken;
    }

    public static String getCallbackResponse(String providerId, String accessToken, String customUrlScheme, String requestSourceType) {
        HashMap<String, String> input = new HashMap<String, String>();
        input.put("providerId", providerId);
        input.put("customUrlScheme", customUrlScheme);
        input.put("requestSourceType", requestSourceType);
        input.put("accessToken", accessToken);
        return StringSubstitutor.replace((Object)new ClassPathFile(OAUTH_CALLBACK_URL_RESPONSE).getContent().asString(), input);
    }

    private static String getScopeValue(OAuth2ProviderConfig oAuth2ProviderConfig) {
        List<Scope> scopesList = oAuth2ProviderConfig.getScopes();
        return scopesList.stream().map(Scope::getValue).distinct().collect(Collectors.joining(" "));
    }
}

