/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.commons.auth.oauth2.extractors;

import com.fasterxml.jackson.databind.JsonMappingException;
import com.wavemaker.commons.auth.oauth2.extractors.AccessTokenExtractor;
import com.wavemaker.commons.auth.oauth2.extractors.AccessTokenRequestContext;
import com.wavemaker.commons.json.JSONUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessTokenInObjectExtractor
implements AccessTokenExtractor {
    private static final Logger logger = LoggerFactory.getLogger(AccessTokenInObjectExtractor.class);

    @Override
    public String getAccessToken(AccessTokenRequestContext accessTokenRequestContext) {
        String accessToken = null;
        try {
            HashMap responseMap = JSONUtils.toObject(accessTokenRequestContext.getResponseBody(), LinkedHashMap.class);
            Object accessTokenObject = responseMap.get("access_token");
            if (accessTokenObject instanceof Map) {
                Map accessTokenMap = (Map)accessTokenObject;
                accessToken = (String)accessTokenMap.get("token");
            }
        }
        catch (JsonMappingException responseMap) {
        }
        catch (IOException ioe) {
            logger.warn("Failed to extract access_token.token path in json string", (Throwable)ioe);
        }
        return accessToken;
    }
}

