/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.commons.auth.oauth2.extractors;

import com.wavemaker.commons.auth.oauth2.extractors.AccessTokenExtractor;
import com.wavemaker.commons.auth.oauth2.extractors.AccessTokenInObjectExtractor;
import com.wavemaker.commons.auth.oauth2.extractors.AccessTokenRequestContext;
import com.wavemaker.commons.auth.oauth2.extractors.FormUrlEncodedFormatAccessTokenExtractor;
import com.wavemaker.commons.auth.oauth2.extractors.JsonFormatAccessTokenExtractor;
import com.wavemaker.commons.auth.oauth2.extractors.XmlFormatAccessTokenExtractor;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessTokenResponseExtractor {
    private static final Logger logger = LoggerFactory.getLogger(AccessTokenResponseExtractor.class);
    private List<AccessTokenExtractor> accessTokenExtractorsList = new ArrayList<AccessTokenExtractor>();

    public AccessTokenResponseExtractor() {
        this.accessTokenExtractorsList.add(new JsonFormatAccessTokenExtractor());
        this.accessTokenExtractorsList.add(new FormUrlEncodedFormatAccessTokenExtractor());
        this.accessTokenExtractorsList.add(new XmlFormatAccessTokenExtractor());
        this.accessTokenExtractorsList.add(new AccessTokenInObjectExtractor());
    }

    public String getAccessToken(AccessTokenRequestContext accessTokenRequestContext) {
        String accessToken = null;
        for (AccessTokenExtractor accessTokenExtractor : this.accessTokenExtractorsList) {
            logger.debug("Using {} to extract accessToken", accessTokenExtractor.getClass());
            accessToken = accessTokenExtractor.getAccessToken(accessTokenRequestContext);
            if (accessToken == null) continue;
            logger.debug("Found accessToken using {}", accessTokenExtractor.getClass());
            return accessToken;
        }
        return accessToken;
    }
}

