/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.commons.classloader;

import com.wavemaker.commons.MessageResource;
import com.wavemaker.commons.WMRuntimeException;
import com.wavemaker.commons.classloader.ClassLoaderUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.IOUtils;
import org.springframework.core.io.Resource;

public class ThrowawayFileClassLoader
extends ClassLoader {
    private final List<Resource> classPath;
    private final ClassLoader parentClassLoader;

    public ThrowawayFileClassLoader(List<Resource> classPath, ClassLoader parent) {
        super(null);
        this.classPath = classPath;
        this.parentClassLoader = parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        Class<?> ret;
        String packageName;
        byte[] fileBytes;
        block16: {
            if (this.classPath == null) {
                throw new ClassNotFoundException("invalid search root: " + this.classPath);
            }
            if (name == null) {
                throw new ClassNotFoundException(MessageResource.NULL_CLASS.getMessage(new Object[0]));
            }
            String classNamePath = name.replace('.', '/') + ".class";
            fileBytes = null;
            try {
                InputStream is = null;
                try (ZipFile jarFile = null;){
                    for (Resource entry : this.classPath) {
                        if (entry.getFilename().toLowerCase().endsWith(".jar")) {
                            jarFile = new JarFile(entry.getFile());
                            ZipEntry ze = ((JarFile)jarFile).getEntry(classNamePath);
                            if (ze != null) {
                                is = ((JarFile)jarFile).getInputStream(ze);
                                break;
                            }
                            jarFile.close();
                            continue;
                        }
                        Resource classFile = entry.createRelative(classNamePath);
                        if (!classFile.exists()) continue;
                        is = classFile.getInputStream();
                        break;
                    }
                    if (is == null) break block16;
                    try {
                        fileBytes = IOUtils.toByteArray(is);
                    }
                    finally {
                        is.close();
                    }
                }
            }
            catch (IOException e) {
                throw new ClassNotFoundException(e.getMessage(), e);
            }
        }
        if (name.contains(".") && this.getPackage(packageName = name.substring(0, name.lastIndexOf(46))) == null) {
            this.definePackage(packageName, "", "", "", "", "", "", null);
        }
        if ((ret = fileBytes == null ? ClassLoaderUtils.loadClass(name, this.parentClassLoader) : this.defineClass(name, fileBytes, 0, fileBytes.length)) == null) {
            throw new ClassNotFoundException("Couldn't find class " + name + " in expected classpath: " + this.classPath);
        }
        return ret;
    }

    @Override
    protected URL findResource(String name) {
        URL ret = null;
        JarFile jarFile = null;
        try {
            for (Resource entry : this.classPath) {
                if (entry.getFilename().toLowerCase().endsWith(".jar")) {
                    jarFile = new JarFile(entry.getFile());
                    ZipEntry ze = jarFile.getEntry(name);
                    jarFile.close();
                    if (ze == null) continue;
                    ret = new URL("jar:" + entry.getURL() + "!/" + name);
                } else {
                    Resource file = entry.createRelative(name);
                    if (!file.exists()) continue;
                    ret = file.getURL();
                }
                break;
            }
        }
        catch (IOException e) {
            throw new WMRuntimeException(e);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getResourceAsStream(String name) {
        URL url = this.getResource(name);
        if (url == null) {
            return null;
        }
        try {
            byte[] b;
            InputStream is = null;
            try {
                is = url.openStream();
                b = IOUtils.toByteArray((InputStream)is);
            }
            finally {
                if (is != null) {
                    is.close();
                }
                url = null;
                is = null;
            }
            return new ByteArrayInputStream(b);
        }
        catch (IOException e) {
            return null;
        }
    }
}

